@extends('layouts.app')

@section('title', __('accounting-reports::lang.reconciliation'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.reconciliation') - {{ $account->name }}</h1>
</section>

<section class="content">
    <div class="box box-solid">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('accounting-reports::lang.reconciliation')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('end_date', __('accounting-reports::lang.as_on_date') . ':') !!}
                        {!! Form::text('end_date', @format_date('now'), ['class' => 'form-control date-picker', 'id' => 'end_date']) !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <br>
                        <button type="button" class="btn btn-primary" id="load_data">
                            <i class="fa fa-refresh"></i> @lang('messages.load')
                        </button>
                    </div>
                </div>
            </div>
            
            <div id="reconciliation_data">
                <p class="text-center">@lang('accounting-reports::lang.select_as_on_date')</p>
            </div>
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script>
$(document).ready(function() {
    $('#load_data').click(function() {
        var end_date = $('#end_date').val();
        if (!end_date) {
            toastr.error('@lang("accounting-reports::lang.please_select_as_on_date")');
            return;
        }
        
        $.ajax({
            url: '{{ route("accounting-reports.bank-book.reconciliation.get-data", $account->id) }}',
            type: 'GET',
            data: { end_date: end_date },
            success: function(response) {
                if (response.success) {
                    renderReconciliationTable(response.unreconciled);
                } else {
                    toastr.error(response.msg || 'Error loading data');
                }
            },
            error: function() {
                toastr.error('@lang("accounting-reports::lang.reconciliation_data_error")');
            }
        });
    });
    
    function renderReconciliationTable(data) {
        var html = '<table class="table table-striped"><thead><tr><th>Date</th><th>Voucher</th><th>Description</th><th>Amount</th><th>Action</th></tr></thead><tbody>';
        data.forEach(function(item) {
            html += '<tr><td>' + item.datetime + '</td><td>' + item.voucher_no + '</td><td>' + item.narration + '</td><td>' + item.amount + '</td><td><button class="btn btn-xs btn-success mark-reconciled" data-id="' + (item.transaction_payment_id || item.cheque_entry_id || '') + '">Mark Reconciled</button></td></tr>';
        });
        html += '</tbody></table>';
        $('#reconciliation_data').html(html);
    }
    
    $(document).on('click', '.mark-reconciled', function() {
        var id = $(this).data('id');
        // TODO: Implement mark as reconciled
        toastr.success('@lang("accounting-reports::lang.reconciliation_marked_success")');
    });
});
</script>
@endsection










