<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.bank_account_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.account_name'):</strong></label>
                        <p>{{ $bankAccount->account_name }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.account_type'):</strong></label>
                        <p>
                            @if($bankAccount->account_type === 'liability')
                                <span class="label label-warning">@lang('accounting-reports::lang.liability')</span>
                            @else
                                <span class="label label-info">@lang('accounting-reports::lang.asset')</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.linked_account'):</strong></label>
                        <p>
                            @if($bankAccount->linkedAccount)
                                <a href="{{ url('/account/account/' . $bankAccount->linked_account_id) }}" target="_blank" class="text-primary">
                                    {{ $bankAccount->linkedAccount->name }} <i class="fa fa-external-link"></i>
                                </a>
                                <br>
                            @else
                                <span class="text-danger">@lang('accounting-reports::lang.not_linked')</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.bank_name'):</strong></label>
                        <p>{{ $bankAccount->bank_name ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.account_number'):</strong></label>
                        <p>{{ $bankAccount->account_number ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.ifsc_code'):</strong></label>
                        <p>{{ $bankAccount->ifsc_code ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.branch_name'):</strong></label>
                        <p>{{ $bankAccount->branch_name ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.opening_balance'):</strong></label>
                        <p><span class="display_currency" data-currency_symbol="true">{{ $bankAccount->opening_balance }}</span></p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.opening_date'):</strong></label>
                        <p>{{ !empty($bankAccount->opening_date) ? @format_date($bankAccount->opening_date) : '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.description'):</strong></label>
                        <p>{{ $bankAccount->description ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.status'):</strong></label>
                        <p>
                            @if($bankAccount->is_active)
                                <span class="label label-success">@lang('accounting-reports::lang.active')</span>
                            @else
                                <span class="label label-danger">@lang('accounting-reports::lang.inactive')</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.created_at'):</strong></label>
                        <p>{{ @format_date($bankAccount->created_at) }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>

