@extends('layouts.app')

@section('title', __('accounting-reports::lang.bank_management') . ' - ' . $bankAccount->account_name)

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.bank_management') - {{ $bankAccount->account_name }}</h1>
</section>

<section class="content">
    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#reconciliation_tab" data-toggle="tab" aria-expanded="true">
                    <i class="fa fa-check-circle"></i> @lang('accounting-reports::lang.bank_reconciliation')
                </a>
            </li>
            <li>
                <a href="#cheque_books_tab" data-toggle="tab" aria-expanded="false">
                    <i class="fa fa-book"></i> @lang('accounting-reports::lang.cheque_books')
                </a>
            </li>
            <li>
                <a href="#cheque_entries_tab" data-toggle="tab" aria-expanded="false">
                    <i class="fa fa-file-text"></i> @lang('accounting-reports::lang.cheque_book_entries')
                </a>
            </li>
        </ul>
        
        <div class="tab-content">
            <!-- Bank Reconciliation Tab -->
            <div class="tab-pane active" id="reconciliation_tab">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">@lang('accounting-reports::lang.bank_reconciliation') - {{ $bankAccount->account_name }}</h3>
                        <div class="box-tools">
                            <button type="button" class="btn btn-sm btn-success" id="export_reconciliation_excel">
                                <i class="fa fa-file-excel-o"></i> @lang('daybook::lang.excel')
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label('reconciliation_date_range', __('report.date_range') . ':') !!}
                                    <div class="input-group">
                                        {!! Form::text('reconciliation_date_range', null, [
                                            'class' => 'form-control', 
                                            'id' => 'reconciliation_date_range', 
                                            'readonly', 
                                            'placeholder' => __('lang_v1.select_a_date_range')
                                        ]) !!}
                                        <span class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <br>
                                    <button type="button" class="btn btn-primary" id="filter_reconciliation_btn">
                                        <i class="fa fa-filter"></i> @lang('daybook::lang.filter')
                                    </button>
                                    <button type="button" class="btn btn-default" id="reset_reconciliation_btn">
                                        <i class="fa fa-refresh"></i> @lang('daybook::lang.reset')
                                    </button>
                                </div>
                            </div>
                        </div>
                        {!! Form::hidden('reconciliation_start_date', '', ['id' => 'reconciliation_start_date']) !!}
                        {!! Form::hidden('reconciliation_end_date', '', ['id' => 'reconciliation_end_date']) !!}
                        
                        <div class="table-responsive" style="margin-top: 15px;">
                            <table class="table table-bordered table-striped" id="reconciliation_table" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('daybook::lang.datetime')</th>
                                        <th>@lang('daybook::lang.voucher_no')</th>
                                        <th>@lang('daybook::lang.module')</th>
                                        <th>@lang('daybook::lang.party')</th>
                                        <th class="text-right">@lang('accounting-reports::lang.deposit') (Dr)</th>
                                        <th class="text-right">@lang('accounting-reports::lang.withdrawal') (Cr)</th>
                                        <th>@lang('accounting-reports::lang.cheque_no')</th>
                                        <th>@lang('accounting-reports::lang.reconciled')</th>
                                        <th>@lang('accounting-reports::lang.bank_statement_ref')</th>
                                        <th>@lang('accounting-reports::lang.cleared_date')</th>
                                        <th>@lang('messages.action')</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Cheque Books Tab -->
            <div class="tab-pane" id="cheque_books_tab">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">@lang('accounting-reports::lang.cheque_books') - {{ $bankAccount->account_name }}</h3>
                        <div class="box-tools">
                            <button type="button" class="btn btn-sm btn-success btn-modal" data-href="{{ route('accounting-reports.cheque-books.create') }}?bank_account_id={{ $bankAccount->id }}" data-container=".cheque_book_modal">
                                <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_cheque_book')
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active">
                                        <a href="#cheque_books_list" aria-controls="cheque_books_list" role="tab" data-toggle="tab">
                                            @lang('accounting-reports::lang.cheque_books')
                                        </a>
                                    </li>
                                    <li role="presentation">
                                        <a href="#all_cheque_numbers" aria-controls="all_cheque_numbers" role="tab" data-toggle="tab">
                                            @lang('accounting-reports::lang.all_cheque_numbers')
                                        </a>
                                    </li>
                                </ul>
                                
                                <div class="tab-content" style="margin-top: 15px;">
                                    <!-- Cheque Books List Tab -->
                                    <div role="tabpanel" class="tab-pane active" id="cheque_books_list">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped" id="cheque_books_table" style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>@lang('accounting-reports::lang.book_name')</th>
                                                        <th>@lang('accounting-reports::lang.book_number')</th>
                                                        <th>@lang('accounting-reports::lang.cheque_range')</th>
                                                        <th>@lang('accounting-reports::lang.total_cheques')</th>
                                                        <th>@lang('accounting-reports::lang.used_cheques')</th>
                                                        <th>@lang('accounting-reports::lang.remaining_cheques')</th>
                                                        <th>@lang('accounting-reports::lang.status')</th>
                                                        <th>@lang('accounting-reports::lang.issue_date')</th>
                                                        <th>@lang('messages.action')</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                    
                                    <!-- All Cheque Numbers Tab -->
                                    <div role="tabpanel" class="tab-pane" id="all_cheque_numbers">
                                        <div class="row" style="margin-bottom: 15px;">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    {!! Form::label('cheque_status_filter', __('accounting-reports::lang.filter_by_status') . ':') !!}
                                                    {!! Form::select('cheque_status_filter', [
                                                        'all' => __('messages.all'),
                                                        'pending' => __('accounting-reports::lang.pending'),
                                                        'issued' => __('accounting-reports::lang.issued'),
                                                        'presented' => __('accounting-reports::lang.presented'),
                                                        'cleared' => __('accounting-reports::lang.cleared'),
                                                        'bounced' => __('accounting-reports::lang.bounced'),
                                                        'cancelled' => __('accounting-reports::lang.cancelled'),
                                                    ], 'all', ['class' => 'form-control', 'id' => 'cheque_status_filter']) !!}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped" id="all_cheque_numbers_table" style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>@lang('accounting-reports::lang.cheque_no')</th>
                                                        <th>@lang('accounting-reports::lang.cheque_book')</th>
                                                        <th>@lang('accounting-reports::lang.cheque_status')</th>
                                                        <th>@lang('accounting-reports::lang.cheque_type')</th>
                                                        <th>@lang('accounting-reports::lang.amount')</th>
                                                        <th>@lang('accounting-reports::lang.payee_name')</th>
                                                        <th>@lang('accounting-reports::lang.cheque_date')</th>
                                                        <th>@lang('accounting-reports::lang.presented_date')</th>
                                                        <th>@lang('accounting-reports::lang.cleared_date')</th>
                                                        <th>@lang('messages.action')</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Cheque Entries Tab -->
            <div class="tab-pane" id="cheque_entries_tab">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">@lang('accounting-reports::lang.cheque_book_entries') - {{ $bankAccount->account_name }}</h3>
                        <div class="box-tools">
                            <button type="button" class="btn btn-sm btn-info" id="view_cheque_history_btn">
                                <i class="fa fa-history"></i> @lang('accounting-reports::lang.cheque_history')
                            </button>
                            <button type="button" class="btn btn-sm btn-success btn-modal" data-href="{{ route('accounting-reports.cheque-book.create') }}?bank_account_id={{ $bankAccount->id }}" data-container=".cheque_entry_modal">
                                <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_cheque_entry')
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('cheque_status_filter', __('accounting-reports::lang.cheque_status') . ':') !!}
                                    {!! Form::select('cheque_status_filter', [
                                        '' => __('messages.all'),
                                        'pending' => __('accounting-reports::lang.pending'),
                                        'cleared' => __('accounting-reports::lang.cleared'),
                                        'bounced' => __('accounting-reports::lang.bounced'),
                                        'cancelled' => __('accounting-reports::lang.cancelled'),
                                        'deposited' => __('accounting-reports::lang.deposited')
                                    ], null, ['class' => 'form-control select2', 'id' => 'cheque_status_filter']) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    {!! Form::label('cheque_type_filter', __('accounting-reports::lang.cheque_type') . ':') !!}
                                    {!! Form::select('cheque_type_filter', [
                                        '' => __('messages.all'),
                                        'issued' => __('accounting-reports::lang.issued'),
                                        'received' => __('accounting-reports::lang.received')
                                    ], null, ['class' => 'form-control select2', 'id' => 'cheque_type_filter']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="cheque_entries_table" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('accounting-reports::lang.cheque_no')</th>
                                        <th>@lang('accounting-reports::lang.cheque_date')</th>
                                        <th>@lang('accounting-reports::lang.cheque_type')</th>
                                        <th>@lang('accounting-reports::lang.payee_name')</th>
                                        <th>@lang('accounting-reports::lang.amount')</th>
                                        <th>@lang('accounting-reports::lang.cheque_status')</th>
                                        <th>@lang('accounting-reports::lang.presented_date')</th>
                                        <th>@lang('accounting-reports::lang.cleared_date')</th>
                                        <th>@lang('messages.action')</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade cheque_book_modal" tabindex="-1" role="dialog"></div>
    <div class="modal fade cheque_entry_modal" tabindex="-1" role="dialog"></div>
    
    <!-- Cheque History Modal -->
    <div class="modal fade" id="cheque_history_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">@lang('accounting-reports::lang.cheque_issue_history') - {{ $bankAccount->account_name }}</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                {!! Form::label('history_start_date', __('report.start_date') . ':') !!}
                                {!! Form::text('history_start_date', null, ['class' => 'form-control date-picker', 'id' => 'history_start_date', 'readonly']) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {!! Form::label('history_end_date', __('report.end_date') . ':') !!}
                                {!! Form::text('history_end_date', null, ['class' => 'form-control date-picker', 'id' => 'history_end_date', 'readonly']) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <br>
                                <button type="button" class="btn btn-primary" id="filter_history_btn">
                                    <i class="fa fa-filter"></i> @lang('daybook::lang.filter')
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="cheque_history_table" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>@lang('accounting-reports::lang.cheque_no')</th>
                                    <th>@lang('accounting-reports::lang.cheque_date')</th>
                                    <th>@lang('accounting-reports::lang.cheque_book')</th>
                                    <th>@lang('accounting-reports::lang.payee_name')</th>
                                    <th class="text-right">@lang('accounting-reports::lang.amount')</th>
                                    <th>@lang('accounting-reports::lang.cheque_status')</th>
                                    <th>@lang('accounting-reports::lang.cleared_date')</th>
                                    <th>@lang('daybook::lang.narration')</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function() {
    var bankAccountId = {{ $bankAccount->id }};
    var linkedAccountId = {{ $bankAccount->linked_account_id }};
    
    // Initialize date range picker for reconciliation
    if (typeof dateRangeSettings !== 'undefined' && $('#reconciliation_date_range').length && typeof moment !== 'undefined') {
        var today = moment();
        var threeMonthsAgo = moment().subtract(3, 'months');
        var threeMonthsAgoFormatted = threeMonthsAgo.format(moment_date_format);
        var todayFormatted = today.format(moment_date_format);
        $('#reconciliation_date_range').val(threeMonthsAgoFormatted + ' ~ ' + todayFormatted);
        $('#reconciliation_start_date').val(threeMonthsAgoFormatted);
        $('#reconciliation_end_date').val(todayFormatted);
        
        $('#reconciliation_date_range').daterangepicker(
            {
                ...dateRangeSettings,
                startDate: threeMonthsAgo,
                endDate: today,
                autoUpdateInput: true
            },
            function (start, end) {
                var startFormatted = start.format(moment_date_format);
                var endFormatted = end.format(moment_date_format);
                $('#reconciliation_date_range').val(startFormatted + ' ~ ' + endFormatted);
                $('#reconciliation_start_date').val(startFormatted);
                $('#reconciliation_end_date').val(endFormatted);
                if (typeof reconciliation_table !== 'undefined' && reconciliation_table) {
                    reconciliation_table.ajax.reload();
                }
            }
        );
    }
    
    // Reconciliation Table
    var reconciliation_table = $('#reconciliation_table').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: '{{ route("accounting-reports.bank-accounts.reconciliation.get-data", $bankAccount->id) }}',
            type: 'GET',
            data: function(d) {
                d.start_date = $('#reconciliation_start_date').val();
                d.end_date = $('#reconciliation_end_date').val();
            },
            dataSrc: function(json) {
                if (json.success && json.unreconciled) {
                    // Format the data for DataTables
                    return json.unreconciled.map(function(entry) {
                        return {
                            datetime: entry.datetime || entry.date || '-',
                            voucher_no: entry.voucher_no || entry.ref_no || '-',
                            module: entry.module || '-',
                            party: entry.party || '-',
                            debit: entry.debit || (entry.type === 'debit' ? entry.amount : 0),
                            credit: entry.credit || (entry.type === 'credit' ? entry.amount : 0),
                            cheque_no: entry.cheque_no || '-',
                            is_reconciled: entry.is_reconciled ? '<span class="label label-success">Yes</span>' : '<span class="label label-warning">No</span>',
                            bank_statement_ref: entry.bank_statement_ref || '-',
                            cleared_date: entry.cleared_date || '-',
                            action: entry.is_reconciled ? '' : '<button class="btn btn-xs btn-success mark_reconciled" data-entry-id="' + (entry.id || '') + '" data-cheque-id="' + (entry.cheque_entry_id || '') + '">Mark Reconciled</button>'
                        };
                    });
                }
                return [];
            }
        },
        columns: [
            { data: 'datetime', name: 'datetime' },
            { data: 'voucher_no', name: 'voucher_no' },
            { data: 'module', name: 'module' },
            { data: 'party', name: 'party' },
            { data: 'debit', name: 'debit', className: 'text-right' },
            { data: 'credit', name: 'credit', className: 'text-right' },
            { data: 'cheque_no', name: 'cheque_no' },
            { data: 'is_reconciled', name: 'is_reconciled' },
            { data: 'bank_statement_ref', name: 'bank_statement_ref' },
            { data: 'cleared_date', name: 'cleared_date' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        order: [[0, 'desc']]
    });
    
    $('#filter_reconciliation_btn').click(function() {
        reconciliation_table.ajax.reload();
    });
    
    $('#reset_reconciliation_btn').click(function() {
        if (typeof moment !== 'undefined') {
            var today = moment();
            var threeMonthsAgo = moment().subtract(3, 'months');
            var threeMonthsAgoFormatted = threeMonthsAgo.format(moment_date_format);
            var todayFormatted = today.format(moment_date_format);
            $('#reconciliation_start_date').val(threeMonthsAgoFormatted);
            $('#reconciliation_end_date').val(todayFormatted);
            if ($('#reconciliation_date_range').length && $('#reconciliation_date_range').data('daterangepicker')) {
                $('#reconciliation_date_range').data('daterangepicker').setStartDate(threeMonthsAgo);
                $('#reconciliation_date_range').data('daterangepicker').setEndDate(today);
                $('#reconciliation_date_range').val(threeMonthsAgoFormatted + ' ~ ' + todayFormatted);
            }
        }
        reconciliation_table.ajax.reload();
    });
    
    // Cheque Books Table
    var cheque_books_table = $('#cheque_books_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("accounting-reports.cheque-books.get-data") }}',
            data: function(d) {
                d.account_id = linkedAccountId;
            }
        },
        columns: [
            { data: 'book_name', name: 'book_name' },
            { data: 'book_number', name: 'book_number' },
            { data: 'cheque_range', name: 'cheque_range' },
            { data: 'total_cheques', name: 'total_cheques' },
            { data: 'used_cheques', name: 'used_cheques' },
            { data: 'remaining_cheques', name: 'remaining_cheques' },
            { data: 'status', name: 'status' },
            { data: 'issue_date', name: 'issue_date' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        order: [[0, 'desc']]
    });
    
    // All Cheque Numbers Table - Initialize only when tab is shown
    var all_cheque_numbers_table = null;
    
    $('a[href="#all_cheque_numbers"]').on('shown.bs.tab', function() {
        if (!all_cheque_numbers_table) {
            all_cheque_numbers_table = $('#all_cheque_numbers_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("accounting-reports.bank-accounts.cheque-numbers.get-data", $bankAccount->id) }}',
                    data: function(d) {
                        d.status = $('#cheque_status_filter').val();
                    }
                },
                columns: [
                    { data: 'cheque_no', name: 'cheque_no' },
                    { data: 'cheque_book_name', name: 'cheque_book_name' },
                    { data: 'status', name: 'status', orderable: false },
                    { data: 'type', name: 'type' },
                    { data: 'amount', name: 'amount' },
                    { data: 'payee_name', name: 'payee_name' },
                    { data: 'cheque_date', name: 'cheque_date' },
                    { data: 'presented_date', name: 'presented_date' },
                    { data: 'cleared_date', name: 'cleared_date' },
                    { data: 'action', name: 'action', orderable: false, searchable: false }
                ],
                order: [[0, 'asc']],
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
            });
            
            // Filter by status
            $('#cheque_status_filter').on('change', function() {
                all_cheque_numbers_table.ajax.reload();
            });
        }
    });
    
    // Cheque Entries Table - Initialize only when tab is shown
    var cheque_entries_table = null;
    
    function initChequeEntriesTable() {
        if (cheque_entries_table) {
            return; // Already initialized
        }
        
        cheque_entries_table = $('#cheque_entries_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("accounting-reports.cheque-book.get-data") }}',
                data: function(d) {
                    d.account_id = linkedAccountId;
                    d.status = $('#cheque_status_filter').val();
                    d.type = $('#cheque_type_filter').val();
                }
            },
            columns: [
                { data: 'cheque_no', name: 'cheque_no' },
                { data: 'cheque_date', name: 'cheque_date' },
                { data: 'type', name: 'type' },
                { data: 'payee_name', name: 'payee_name' },
                { data: 'amount', name: 'amount', className: 'text-right' },
                { data: 'status', name: 'status' },
                { data: 'presented_date', name: 'presented_date' },
                { data: 'cleared_date', name: 'cleared_date' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            order: [[1, 'desc']]
        });
    }
    
    $('#cheque_status_filter, #cheque_type_filter').on('change', function() {
        if (cheque_entries_table) {
            cheque_entries_table.ajax.reload();
        }
    });
    
    // Initialize modals
    $(document).on('click', '.btn-modal', function(e) {
        e.preventDefault();
        var container = $(this).data('container');
        var href = $(this).data('href');
        $(container).load(href, function() {
            $(this).modal('show');
            // Initialize form elements after modal is shown
            setTimeout(function() {
                // Initialize date pickers
                $('.date-picker', container).datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
                // Initialize select2 with proper dropdown parent
                $('.select2', container).select2({
                    dropdownParent: $(container),
                    width: '100%'
                });
                // Trigger initialization if account is pre-selected
                var selectedAccountId = $('select#account_id', container).val();
                if (selectedAccountId) {
                    // Trigger change event to load cheques
                    $('select#account_id', container).trigger('change');
                }
            }, 300);
        });
    });
    
    // Also handle modal shown event for cheque entry modal
    $(document).on('shown.bs.modal', '.cheque_entry_modal', function() {
        var container = $(this);
        // Re-initialize select2 with proper dropdown parent
        $('.select2', container).select2({
            dropdownParent: container,
            width: '100%'
        });
        // Trigger account change if account is pre-selected
        var selectedAccountId = $('select#account_id', container).val();
        if (selectedAccountId) {
            setTimeout(function() {
                $('select#account_id', container).trigger('change');
            }, 100);
        }
    });
    
    // Reload tables when tab changes
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href");
        if (target === '#reconciliation_tab') {
            reconciliation_table.ajax.reload();
        } else if (target === '#cheque_books_tab') {
            cheque_books_table.ajax.reload();
        } else if (target === '#cheque_entries_tab') {
            if (!cheque_entries_table) {
                initChequeEntriesTable();
            } else {
                cheque_entries_table.ajax.reload();
            }
        }
    });
    
    // Issue Cheque Button - Opens modal with pre-filled data (from all cheque numbers table)
    $(document).on('click', '#all_cheque_numbers_table .issue_cheque_btn', function() {
        var url = $(this).data('href');
        
        if (!url) {
            toastr.error('@lang("messages.something_went_wrong")');
            return;
        }
        
        // Create modal container if it doesn't exist
        if ($('.issue_cheque_modal').length === 0) {
            $('body').append('<div class="modal fade issue_cheque_modal" tabindex="-1" role="dialog"></div>');
        }
        
        var modal = $('.issue_cheque_modal');
        
        // Load modal content
        $.ajax({
            url: url,
            dataType: 'html',
            success: function(result) {
                modal.html(result).modal('show');
            },
            error: function() {
                toastr.error('@lang("messages.something_went_wrong")');
            }
        });
    });
    
    // Mark as reconciled
    $(document).on('click', '.mark_reconciled', function() {
        var entryId = $(this).data('entry-id');
        var chequeId = $(this).data('cheque-id');
        var row = $(this).closest('tr');
        
        $.ajax({
            url: '{{ route("accounting-reports.bank-accounts.reconciliation.mark") }}',
            method: 'POST',
            data: {
                transaction_payment_id: entryId,
                cheque_entry_id: chequeId,
                cleared_date: $('#reconciliation_end_date').val() || new Date().toISOString().split('T')[0],
                bank_statement_ref: prompt('Enter Bank Statement Reference (optional):') || ''
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.msg);
                    reconciliation_table.ajax.reload();
                } else {
                    toastr.error(response.msg);
                }
            },
            error: function() {
                toastr.error('Error marking transaction as reconciled');
            }
        });
    });
    
    // Cheque History
    var cheque_history_table = null;
    $('#view_cheque_history_btn').click(function() {
        $('#cheque_history_modal').modal('show');
        
        if (!cheque_history_table) {
            cheque_history_table = $('#cheque_history_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("accounting-reports.cheque-book.history.get-data") }}',
                    data: function(d) {
                        d.account_id = linkedAccountId;
                        d.start_date = $('#history_start_date').val();
                        d.end_date = $('#history_end_date').val();
                    }
                },
                columns: [
                    { data: 'cheque_no', name: 'cheque_no' },
                    { data: 'cheque_date', name: 'cheque_date' },
                    { data: 'cheque_book_name', name: 'cheque_book_name' },
                    { data: 'payee_name', name: 'payee_name' },
                    { data: 'amount', name: 'amount', className: 'text-right' },
                    { data: 'status', name: 'status' },
                    { data: 'cleared_date', name: 'cleared_date' },
                    { data: 'narration', name: 'narration' }
                ],
                order: [[1, 'desc']]
            });
        }
    });
    
    $('#filter_history_btn').click(function() {
        if (cheque_history_table) {
            cheque_history_table.ajax.reload();
        }
    });
    
    // Initialize date pickers in history modal
    $('#cheque_history_modal').on('shown.bs.modal', function() {
        if (typeof datepicker_params !== 'undefined') {
            $('#history_start_date, #history_end_date').datepicker(datepicker_params);
        }
    });
});
</script>
@endsection

