@extends('layouts.app')

@section('title', __('accounting-reports::lang.bank_accounts'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.bank_accounts')</h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ action([\Modules\AccountingReports\Http\Controllers\BankAccountController::class, 'create']) }}" data-container=".bank_account_modal">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_bank_account')
                    </button>
                </div>
            </div>
        </div>
        <br>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="bank_accounts_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.account_name')</th>
                        <th>@lang('accounting-reports::lang.account_type')</th>
                        <th>@lang('accounting-reports::lang.bank_name')</th>
                        <th>@lang('accounting-reports::lang.account_number')</th>
                        <th>@lang('accounting-reports::lang.linked_account')</th>
                        <th>@lang('accounting-reports::lang.opening_balance')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('accounting-reports::lang.created_at')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
    
    <div class="modal fade bank_account_modal" tabindex="-1" role="dialog"></div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('.date-picker').datepicker({
            autoclose: true,
            format: datepicker_date_format
        });
        
        var bank_accounts_table = $('#bank_accounts_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\AccountingReports\Http\Controllers\BankAccountController::class, "getData"]) }}',
                data: function(d) {
                    d.account_type = $('#filter_account_type').val();
                    d.is_active = $('#filter_is_active').val();
                }
            },
            columns: [
                { data: 'account_name', name: 'account_name' },
                { data: 'account_type', name: 'account_type' },
                { data: 'bank_name', name: 'bank_name' },
                { data: 'account_number', name: 'account_number' },
                { data: 'linked_account_id', name: 'linked_account_id' },
                { data: 'opening_balance', name: 'opening_balance' },
                { data: 'is_active', name: 'is_active' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        $(document).on('click', '.edit_bank_account', function(e) {
            e.preventDefault();
            $('div.bank_account_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                $('form#bank_account_form').submit(function(e) {
                    e.preventDefault();
                    $.ajax({
                        method: 'POST',
                        url: $(this).attr('action'),
                        data: $(this).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                $('div.bank_account_modal').modal('hide');
                                toastr.success(response.msg);
                                bank_accounts_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                });
            });
        });

        $(document).on('click', '.view_bank_account', function(e) {
            e.preventDefault();
            $('div.bank_account_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });

        $(document).on('click', '.view_ledger', function(e) {
            e.preventDefault();
            var url = $(this).data('href');
            window.location.href = url;
        });

        $(document).on('click', '.manage_bank', function(e) {
            e.preventDefault();
            var url = $(this).data('href');
            window.location.href = url;
        });

        $(document).on('click', '.delete_bank_account', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                text: '{{ __("accounting-reports::lang.confirm_delete_bank_account") }}',
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                bank_accounts_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('submit', 'form#add_bank_account_form', function(e) {
            e.preventDefault();
            $(this).validate();
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('div.bank_account_modal').modal('hide');
                            toastr.success(response.msg);
                            bank_accounts_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            }
        });
        
        // Initialize modal
        $(document).on('click', '.btn-modal', function(e) {
            e.preventDefault();
            $('div.bank_account_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                // Initialize date picker and select2 in modal after a short delay to ensure DOM is ready
                setTimeout(function() {
                    $('.date-picker').datepicker({
                        autoclose: true,
                        format: datepicker_date_format
                    });
                    $('.select2').select2({
                        dropdownParent: $('.bank_account_modal')
                    });
                }, 300);
            });
        });
        
        // Initialize date picker and select2 when edit modal loads
        $(document).on('click', '.edit_bank_account', function(e) {
            setTimeout(function() {
                $('.date-picker').datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
                $('.select2').select2({
                    dropdownParent: $('.bank_account_modal')
                });
            }, 300);
        });
    });
</script>
@endsection

