<div class="modal-dialog">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\BankAccountController::class, 'update'], [$bankAccount->id]), 'method' => 'put', 'id' => 'bank_account_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.edit_bank_account')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('account_name', __('accounting-reports::lang.account_name') . ':*') !!}
                        {!! Form::text('account_name', $bankAccount->account_name, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.account_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_type', __('accounting-reports::lang.account_type') . ':*') !!}
                        {!! Form::select('account_type', [
                            '' => __('messages.please_select'),
                            'asset' => __('accounting-reports::lang.asset'),
                            'liability' => __('accounting-reports::lang.liability')
                        ], $bankAccount->account_type, ['class' => 'form-control select2', 'style' => 'width:100%', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('linked_account_id', __('accounting-reports::lang.linked_account') . ':') !!}
                        {!! Form::select('linked_account_id', $availableAccounts, $bankAccount->linked_account_id, ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                        <small class="help-block">@lang('accounting-reports::lang.linked_account_help')</small>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_name', __('accounting-reports::lang.bank_name') . ':') !!}
                        {!! Form::text('bank_name', $bankAccount->bank_name, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.bank_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_number', __('accounting-reports::lang.account_number') . ':') !!}
                        {!! Form::text('account_number', $bankAccount->account_number, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.account_number')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('ifsc_code', __('accounting-reports::lang.ifsc_code') . ':') !!}
                        {!! Form::text('ifsc_code', $bankAccount->ifsc_code, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.ifsc_code')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('branch_name', __('accounting-reports::lang.branch_name') . ':') !!}
                        {!! Form::text('branch_name', $bankAccount->branch_name, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.branch_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_balance', __('accounting-reports::lang.opening_balance') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('opening_balance', $bankAccount->opening_balance, ['class' => 'form-control input_number', 'placeholder' => __('accounting-reports::lang.opening_balance')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_date', __('accounting-reports::lang.opening_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('opening_date', !empty($bankAccount->opening_date) ? @format_date($bankAccount->opening_date) : null, ['class' => 'form-control date-picker', 'readonly', 'placeholder' => __('accounting-reports::lang.opening_date')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', $bankAccount->description, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                {!! Form::checkbox('is_active', 1, $bankAccount->is_active) !!}
                                @lang('accounting-reports::lang.active')
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

