<div class="modal-dialog">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\BankAccountController::class, 'store']), 'method' => 'post', 'id' => 'add_bank_account_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.add_bank_account')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('account_name', __('accounting-reports::lang.account_name') . ':*') !!}
                        {!! Form::text('account_name', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.account_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_type', __('accounting-reports::lang.account_type') . ':*') !!}
                        {!! Form::select('account_type', [
                            '' => __('messages.please_select'),
                            'asset' => __('accounting-reports::lang.asset'),
                            'liability' => __('accounting-reports::lang.liability')
                        ], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('linked_account_id', __('accounting-reports::lang.linked_account') . ':') !!}
                        {!! Form::select('linked_account_id', $availableAccounts, null, ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                        <small class="help-block">@lang('accounting-reports::lang.linked_account_help')</small>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_name', __('accounting-reports::lang.bank_name') . ':') !!}
                        {!! Form::text('bank_name', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.bank_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_number', __('accounting-reports::lang.account_number') . ':') !!}
                        {!! Form::text('account_number', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.account_number')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('ifsc_code', __('accounting-reports::lang.ifsc_code') . ':') !!}
                        {!! Form::text('ifsc_code', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.ifsc_code')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('branch_name', __('accounting-reports::lang.branch_name') . ':') !!}
                        {!! Form::text('branch_name', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.branch_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_balance', __('accounting-reports::lang.opening_balance') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('opening_balance', 0, ['class' => 'form-control input_number', 'placeholder' => __('accounting-reports::lang.opening_balance')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_date', __('accounting-reports::lang.opening_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('opening_date', null, ['class' => 'form-control date-picker', 'readonly', 'placeholder' => __('accounting-reports::lang.opening_date')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                {!! Form::checkbox('is_active', 1, true) !!}
                                @lang('accounting-reports::lang.active')
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

