<?php

namespace Modules\AccountingReports\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreChequeEntryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->user()->can('accounting.add_cheque_entry');
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'bank_account_id' => 'required|exists:ar_bank_accounts,id',
            'cheque_book_id' => 'nullable|exists:ar_cheque_books,id',
            'cheque_number' => 'required|string|max:50',
            'cheque_date' => 'required|date',
            'type' => 'required|in:issued,received',
            'status' => 'nullable|in:pending,cleared,bounced,cancelled,deposited',
            'amount' => 'nullable|numeric|min:0',
            'payee_name' => 'nullable|string|max:255',
            'description' => 'nullable|string',
            'transaction_payment_id' => 'nullable|exists:transaction_payments,id',
            'account_transaction_id' => 'nullable|exists:account_transactions,id',
            'presented_date' => 'nullable|date',
            'cleared_date' => 'nullable|date',
            'bounced_date' => 'nullable|date',
            'bounce_reason' => 'nullable|string|max:500',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'bank_account_id.required' => 'Bank account is required.',
            'bank_account_id.exists' => 'Selected bank account does not exist.',
            'cheque_number.required' => 'Cheque number is required.',
            'cheque_date.required' => 'Cheque date is required.',
            'cheque_date.date' => 'Cheque date must be a valid date.',
            'type.required' => 'Cheque type is required.',
            'type.in' => 'Cheque type must be either issued or received.',
            'status.in' => 'Invalid cheque status.',
            'amount.numeric' => 'Amount must be a number.',
            'amount.min' => 'Amount cannot be negative.',
        ];
    }
}

