<?php

namespace Modules\AccountingReports\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReconcileTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->user()->can('accounting.reconcile_bankbook');
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'transaction_ids' => 'required|array',
            'transaction_ids.*' => 'required|integer|exists:account_transactions,id',
            'cleared_date' => 'required|date',
            'bank_statement_ref' => 'nullable|string|max:255',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'transaction_ids.required' => 'At least one transaction must be selected.',
            'transaction_ids.array' => 'Transaction IDs must be an array.',
            'transaction_ids.*.exists' => 'One or more selected transactions do not exist.',
            'cleared_date.required' => 'Cleared date is required.',
            'cleared_date.date' => 'Cleared date must be a valid date.',
        ];
    }
}

