<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;

class RatioSnapshot extends Model
{
    protected $table = 'ar_ratio_snapshots';

    protected $guarded = ['id'];

    protected $casts = [
        'snapshot_date' => 'date',
        'current_ratio' => 'decimal:4',
        'quick_ratio' => 'decimal:4',
        'debt_to_equity' => 'decimal:4',
        'interest_coverage' => 'decimal:4',
        'gross_margin' => 'decimal:4',
        'operating_margin' => 'decimal:4',
        'net_margin' => 'decimal:4',
        'roa' => 'decimal:4',
        'roe' => 'decimal:4',
        'inventory_turnover' => 'decimal:4',
        'receivable_days' => 'decimal:4',
        'payable_days' => 'decimal:4',
        'cash_conversion_cycle' => 'decimal:4',
        'sales_growth' => 'decimal:4',
        'gp_growth' => 'decimal:4',
        'pat_growth' => 'decimal:4',
        'raw_values' => 'array',
    ];

    /**
     * Relationships
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }
}


