<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LoanTransaction extends Model
{
    use SoftDeletes;

    protected $table = 'ar_loan_transactions';

    protected $fillable = [
        'loan_id',
        'business_id',
        'transaction_number',
        'transaction_type',
        'transaction_date',
        'principal_amount',
        'interest_amount',
        'total_amount',
        'payment_account_id',
        'payment_method',
        'cheque_number',
        'bank_name',
        'account_transaction_id',
        'notes',
        'reference_no',
        'document',
        'created_by',
    ];

    protected $casts = [
        'principal_amount' => 'decimal:2',
        'interest_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
        'transaction_date' => 'date',
    ];

    /**
     * Get the loan
     */
    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id');
    }

    /**
     * Get the business
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    /**
     * Get the payment account
     */
    public function paymentAccount()
    {
        return $this->belongsTo(\App\Account::class, 'payment_account_id');
    }

    /**
     * Get the account transaction
     */
    public function accountTransaction()
    {
        return $this->belongsTo(\App\AccountTransaction::class, 'account_transaction_id');
    }

    /**
     * Get the user who created this transaction
     */
    public function creator()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }
}







