<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;

class JournalEntryLine extends Model
{
    protected $table = 'ar_journal_entry_lines';

    protected $guarded = ['id'];

    protected $casts = [
        'debit' => 'decimal:4',
        'credit' => 'decimal:4',
        'amount' => 'decimal:4',
    ];

    /**
     * Relationships
     */
    public function journalEntry()
    {
        return $this->belongsTo(JournalEntryHeader::class, 'journal_entry_id');
    }

    public function account()
    {
        return $this->belongsTo(ChartOfAccount::class, 'account_id');
    }

    public function contact()
    {
        return $this->belongsTo(\App\Contact::class, 'contact_id');
    }

    public function product()
    {
        return $this->belongsTo(\App\Product::class, 'product_id');
    }

    public function variation()
    {
        return $this->belongsTo(\App\Variation::class, 'variation_id');
    }

    public function tax()
    {
        return $this->belongsTo(\App\TaxRate::class, 'tax_id');
    }

    public function fifoLayer()
    {
        return $this->belongsTo(FifoLayer::class, 'fifo_layer_id');
    }

    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }
}


