<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Investment extends Model
{
    use SoftDeletes;

    protected $table = 'ar_investments';

    protected $fillable = [
        'business_id',
        'name',
        'description',
        'investment_date',
        'amount',
        'current_value',
        'investment_type',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'investment_date' => 'date',
        'amount' => 'decimal:2',
        'current_value' => 'decimal:2',
    ];

    /**
     * Get the business that owns this investment
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    /**
     * Get the user who created this investment
     */
    public function creator()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }

    /**
     * Get the value to use for balance sheet (current value if available, otherwise amount)
     */
    public function getBalanceSheetValueAttribute()
    {
        return $this->current_value ?? $this->amount;
    }
}

