<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FixedAssetRevaluation extends Model
{
    use SoftDeletes;

    protected $table = 'ar_fixed_asset_revaluations';

    protected $fillable = [
        'fixed_asset_id',
        'business_id',
        'revaluation_date',
        'previous_value',
        'revaluation_amount',
        'revaluation_difference',
        'reason',
        'notes',
        'created_by',
    ];

    protected $casts = [
        'revaluation_date' => 'date',
        'previous_value' => 'decimal:2',
        'revaluation_amount' => 'decimal:2',
        'revaluation_difference' => 'decimal:2',
    ];

    /**
     * Get the fixed asset
     */
    public function fixedAsset()
    {
        return $this->belongsTo(FixedAsset::class, 'fixed_asset_id');
    }

    /**
     * Get the business
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    /**
     * Get the user who created this revaluation
     */
    public function creator()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }
}

