<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DirectIncome extends Model
{
    use SoftDeletes;

    protected $table = 'ar_direct_incomes';

    protected $fillable = [
        'business_id',
        'name',
        'description',
        'amount',
        'income_date',
        'location_id',
        'account_id',
        'reference_no',
        'document',
        'created_by',
        'payment_amount',
        'payment_method',
        'payment_account_id',
        'received_on',
        'payment_note',
        'payment_status',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'payment_amount' => 'decimal:2',
        'income_date' => 'date',
        'received_on' => 'datetime',
    ];

    /**
     * Get the business that owns the direct income
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    /**
     * Get the location
     */
    public function location()
    {
        return $this->belongsTo(\App\BusinessLocation::class, 'location_id');
    }

    /**
     * Get the account
     */
    public function account()
    {
        return $this->belongsTo(\App\Account::class, 'account_id');
    }

    /**
     * Get the payment account
     */
    public function paymentAccount()
    {
        return $this->belongsTo(\App\Account::class, 'payment_account_id');
    }

    /**
     * Get the user who created this income
     */
    public function creator()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }
}


