<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CapitalAccount extends Model
{
    use SoftDeletes;

    protected $table = 'ar_capital_accounts';

    protected $fillable = [
        'business_id',
        'account_name',
        'account_type',
        'description',
        'opening_balance',
        'current_balance',
        'opening_date',
        'contact_person',
        'contact_email',
        'contact_phone',
        'address',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'opening_date' => 'date',
        'opening_balance' => 'decimal:2',
        'current_balance' => 'decimal:2',
    ];

    /**
     * Get the business that owns the capital account
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    /**
     * Get the user who created this capital account
     */
    public function creator()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }

    /**
     * Get account type label
     */
    public function getAccountTypeLabelAttribute()
    {
        $types = [
            'owner' => 'Owner',
            'partner' => 'Partner',
            'shareholder' => 'Shareholder',
            'investor' => 'Investor',
            'other' => 'Other',
        ];
        
        return $types[$this->account_type] ?? ucfirst($this->account_type);
    }
}

