<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;

class BankReconciliation extends Model
{
    protected $table = 'ar_bank_reconciliation';

    protected $guarded = ['id'];

    protected $casts = [
        'transaction_date' => 'date',
        'amount' => 'decimal:4',
        'is_cleared' => 'boolean',
        'cleared_date' => 'date',
        'bank_statement_date' => 'date',
    ];

    /**
     * Relationships
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    public function account()
    {
        return $this->belongsTo(ChartOfAccount::class, 'account_id');
    }

    public function journalEntryLine()
    {
        return $this->belongsTo(JournalEntryLine::class, 'journal_entry_line_id');
    }

    public function accountTransaction()
    {
        return $this->belongsTo(\App\AccountTransaction::class, 'account_transaction_id');
    }

    public function clearedBy()
    {
        return $this->belongsTo(\App\User::class, 'cleared_by');
    }
}


