<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ar_cheque_book_entries', function (Blueprint $table) {
            // Add bank_account_id column if it doesn't exist
            if (!Schema::hasColumn('ar_cheque_book_entries', 'bank_account_id')) {
                $table->integer('bank_account_id')->unsigned()->nullable()->after('account_id');
                $table->foreign('bank_account_id')->references('id')->on('ar_bank_accounts')->onDelete('cascade');
                $table->index('bank_account_id');
            }
            
            // Rename cheque_no to cheque_number for consistency
            if (Schema::hasColumn('ar_cheque_book_entries', 'cheque_no')) {
                $table->renameColumn('cheque_no', 'cheque_number');
            }
            
            // Add account_transaction_id if it doesn't exist
            if (!Schema::hasColumn('ar_cheque_book_entries', 'account_transaction_id')) {
                $table->integer('account_transaction_id')->unsigned()->nullable()->after('transaction_payment_id');
                $table->foreign('account_transaction_id')->references('id')->on('account_transactions')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ar_cheque_book_entries', function (Blueprint $table) {
            if (Schema::hasColumn('ar_cheque_book_entries', 'bank_account_id')) {
                $table->dropForeign(['bank_account_id']);
                $table->dropIndex(['bank_account_id']);
                $table->dropColumn('bank_account_id');
            }
            
            if (Schema::hasColumn('ar_cheque_book_entries', 'cheque_number')) {
                $table->renameColumn('cheque_number', 'cheque_no');
            }
            
            if (Schema::hasColumn('ar_cheque_book_entries', 'account_transaction_id')) {
                $table->dropForeign(['account_transaction_id']);
                $table->dropColumn('account_transaction_id');
            }
        });
    }
};

