<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ar_bank_reconciliation', function (Blueprint $table) {
            $table->integer('account_transaction_id')->unsigned()->nullable()->after('journal_entry_line_id');
            $table->foreign('account_transaction_id')->references('id')->on('account_transactions')->onDelete('cascade');
            $table->index('account_transaction_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ar_bank_reconciliation', function (Blueprint $table) {
            $table->dropForeign(['account_transaction_id']);
            $table->dropIndex(['account_transaction_id']);
            $table->dropColumn('account_transaction_id');
        });
    }
};

