<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ar_bank_accounts', function (Blueprint $table) {
            $table->integer('opening_balance_transaction_id')->unsigned()->nullable()->after('opening_date')->comment('Reference to account_transactions table for opening balance');
            $table->foreign('opening_balance_transaction_id')->references('id')->on('account_transactions')->onDelete('set null');
            $table->index('opening_balance_transaction_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ar_bank_accounts', function (Blueprint $table) {
            $table->dropForeign(['opening_balance_transaction_id']);
            $table->dropIndex(['opening_balance_transaction_id']);
            $table->dropColumn('opening_balance_transaction_id');
        });
    }
};

