<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_investments', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            $table->string('name');
            $table->text('description')->nullable();
            $table->date('investment_date')->nullable();
            $table->decimal('amount', 15, 2)->default(0)->comment('Initial investment amount');
            $table->decimal('current_value', 15, 2)->nullable()->comment('Current market value');
            $table->string('investment_type')->nullable()->comment('e.g., stocks, bonds, mutual funds, commodities, etc.');
            $table->boolean('is_active')->default(true);
            
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['business_id', 'is_active']);
            $table->unique(['business_id', 'name']); // Unique name per business
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_investments');
    }
};

