<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_fixed_asset_revaluations', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('fixed_asset_id')->unsigned();
            $table->foreign('fixed_asset_id')->references('id')->on('ar_fixed_assets')->onDelete('cascade');
            
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            $table->date('revaluation_date');
            $table->decimal('previous_value', 15, 2);
            $table->decimal('revaluation_amount', 15, 2)->comment('New book value after revaluation');
            $table->decimal('revaluation_difference', 15, 2)->comment('Difference (revaluation_amount - previous_value)');
            $table->text('reason')->nullable()->comment('Reason for revaluation');
            $table->text('notes')->nullable();
            
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['fixed_asset_id', 'business_id']);
            $table->index('revaluation_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_fixed_asset_revaluations');
    }
};

