<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ar_fixed_assets', function (Blueprint $table) {
            $table->decimal('current_book_value', 15, 2)->nullable()->after('amount')->comment('Current book value after revaluations');
            $table->decimal('accumulated_depreciation', 15, 2)->default(0)->after('current_book_value')->comment('Total accumulated depreciation');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ar_fixed_assets', function (Blueprint $table) {
            $table->dropColumn(['current_book_value', 'accumulated_depreciation']);
        });
    }
};

