<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ar_fixed_assets', function (Blueprint $table) {
            $table->date('purchase_date')->nullable()->after('description');
            $table->decimal('amount', 15, 2)->default(0)->after('purchase_date');
            $table->decimal('depreciation_percentage', 5, 2)->nullable()->after('amount')->comment('Depreciation percentage per year');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ar_fixed_assets', function (Blueprint $table) {
            $table->dropColumn(['purchase_date', 'amount', 'depreciation_percentage']);
        });
    }
};

