<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_loan_transactions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('loan_id')->unsigned();
            $table->foreign('loan_id')->references('id')->on('ar_loans')->onDelete('cascade');
            
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            $table->string('transaction_number')->unique();
            $table->enum('transaction_type', ['loan_receipt', 'principal_repayment', 'interest_payment', 'full_repayment'])->default('loan_receipt');
            $table->date('transaction_date');
            
            // Amounts
            $table->decimal('principal_amount', 20, 2)->default(0);
            $table->decimal('interest_amount', 20, 2)->default(0);
            $table->decimal('total_amount', 20, 2);
            
            // Payment details
            $table->integer('payment_account_id')->unsigned()->nullable();
            $table->foreign('payment_account_id')->references('id')->on('accounts')->onDelete('set null');
            $table->string('payment_method')->nullable();
            $table->string('cheque_number')->nullable();
            $table->string('bank_name')->nullable();
            
            // Account transaction reference
            $table->integer('account_transaction_id')->unsigned()->nullable();
            $table->foreign('account_transaction_id')->references('id')->on('account_transactions')->onDelete('set null');
            
            $table->text('notes')->nullable();
            $table->string('reference_no')->nullable();
            $table->string('document')->nullable();
            
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['loan_id', 'transaction_date']);
            $table->index(['business_id', 'transaction_type']);
            $table->index('transaction_number');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_loan_transactions');
    }
};







