<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_loans', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            $table->string('loan_number')->unique();
            $table->string('loan_name');
            $table->text('description')->nullable();
            
            // Loan details
            $table->decimal('loan_amount', 20, 2);
            $table->decimal('interest_rate', 5, 2)->default(0);
            $table->enum('interest_type', ['flat', 'reducing'])->default('flat');
            $table->date('loan_date');
            $table->date('maturity_date')->nullable();
            
            // Lender/Provider information
            $table->string('lender_name');
            $table->string('lender_contact')->nullable();
            $table->text('lender_address')->nullable();
            
            // Account information
            $table->integer('liability_account_id')->unsigned()->nullable();
            $table->foreign('liability_account_id')->references('id')->on('accounts')->onDelete('set null');
            $table->integer('payment_account_id')->unsigned()->nullable();
            $table->foreign('payment_account_id')->references('id')->on('accounts')->onDelete('set null');
            
            // Location
            $table->integer('location_id')->unsigned()->nullable();
            $table->foreign('location_id')->references('id')->on('business_locations')->onDelete('set null');
            
            // Status
            $table->enum('status', ['active', 'closed', 'defaulted'])->default('active');
            $table->decimal('principal_paid', 20, 2)->default(0);
            $table->decimal('interest_paid', 20, 2)->default(0);
            $table->decimal('outstanding_principal', 20, 2);
            $table->decimal('outstanding_interest', 20, 2)->default(0);
            
            // Documents
            $table->string('document')->nullable();
            $table->string('reference_no')->nullable();
            
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['business_id', 'loan_date']);
            $table->index(['business_id', 'status']);
            $table->index('loan_number');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_loans');
    }
};







