<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_ratio_snapshots', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            // Snapshot date
            $table->date('snapshot_date');
            $table->enum('period_type', ['daily', 'monthly', 'quarterly', 'yearly'])->default('monthly');
            
            // Liquidity ratios
            $table->decimal('current_ratio', 15, 4)->nullable();
            $table->decimal('quick_ratio', 15, 4)->nullable();
            
            // Leverage ratios
            $table->decimal('debt_to_equity', 15, 4)->nullable();
            $table->decimal('interest_coverage', 15, 4)->nullable();
            
            // Profitability ratios
            $table->decimal('gross_margin', 15, 4)->nullable();
            $table->decimal('operating_margin', 15, 4)->nullable();
            $table->decimal('net_margin', 15, 4)->nullable();
            $table->decimal('roa', 15, 4)->nullable();
            $table->decimal('roe', 15, 4)->nullable();
            
            // Efficiency ratios
            $table->decimal('inventory_turnover', 15, 4)->nullable();
            $table->decimal('receivable_days', 15, 4)->nullable();
            $table->decimal('payable_days', 15, 4)->nullable();
            $table->decimal('cash_conversion_cycle', 15, 4)->nullable();
            
            // Growth metrics
            $table->decimal('sales_growth', 15, 4)->nullable();
            $table->decimal('gp_growth', 15, 4)->nullable();
            $table->decimal('pat_growth', 15, 4)->nullable();
            
            // Raw values used in calculations (JSON)
            $table->json('raw_values')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->unique(['business_id', 'snapshot_date', 'period_type']);
            $table->index(['business_id', 'snapshot_date']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_ratio_snapshots');
    }
};


