<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_audit_log', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            // Action details
            $table->enum('action_type', [
                'create', 'update', 'delete', 'post', 'reverse', 
                'reconcile', 'rebuild', 'lock_period', 'unlock_period'
            ]);
            $table->enum('entity_type', [
                'journal_entry', 'account', 'fifo_layer', 'reconciliation', 
                'period_lock', 'ledger_rollup'
            ]);
            $table->integer('entity_id')->unsigned()->nullable();
            
            // Changes (JSON)
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            $table->text('description')->nullable();
            
            // User & IP
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('ip_address', 45)->nullable();
            $table->string('user_agent')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['business_id', 'entity_type', 'entity_id']);
            $table->index(['business_id', 'user_id', 'created_at']);
            $table->index(['business_id', 'action_type', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_audit_log');
    }
};


