<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_bank_reconciliation', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            $table->integer('account_id')->unsigned()->comment('Bank account from ar_chart_of_accounts');
            $table->foreign('account_id')->references('id')->on('ar_chart_of_accounts')->onDelete('cascade');
            
            // Journal entry line reference
            $table->integer('journal_entry_line_id')->unsigned();
            $table->foreign('journal_entry_line_id')->references('id')->on('ar_journal_entry_lines')->onDelete('cascade');
            
            // Reconciliation details
            $table->date('transaction_date');
            $table->decimal('amount', 22, 4);
            $table->string('reference', 255)->nullable();
            $table->text('description')->nullable();
            
            // Cleared status
            $table->boolean('is_cleared')->default(false);
            $table->date('cleared_date')->nullable();
            $table->integer('cleared_by')->unsigned()->nullable();
            $table->foreign('cleared_by')->references('id')->on('users')->onDelete('set null');
            
            // Bank statement matching
            $table->string('bank_statement_ref', 255)->nullable();
            $table->date('bank_statement_date')->nullable();
            
            $table->timestamps();
            
            // Indexes - using custom names to avoid MySQL 64-character limit
            $table->index(['business_id', 'account_id', 'is_cleared'], 'ar_bank_recon_cleared_idx');
            $table->index(['business_id', 'account_id', 'transaction_date'], 'ar_bank_recon_date_idx');
            $table->unique(['journal_entry_line_id'], 'ar_bank_recon_jel_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_bank_reconciliation');
    }
};


