<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_period_locks', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            // Period details
            $table->date('period_start');
            $table->date('period_end');
            $table->enum('period_type', ['month', 'quarter', 'year'])->default('month');
            
            // Lock status
            $table->boolean('is_locked')->default(false);
            $table->text('lock_reason')->nullable();
            
            // Audit
            $table->integer('locked_by')->unsigned()->nullable();
            $table->foreign('locked_by')->references('id')->on('users')->onDelete('set null');
            $table->dateTime('locked_at')->nullable();
            $table->integer('unlocked_by')->unsigned()->nullable();
            $table->foreign('unlocked_by')->references('id')->on('users')->onDelete('set null');
            $table->dateTime('unlocked_at')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->unique(['business_id', 'period_start', 'period_end']);
            $table->index(['business_id', 'is_locked']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_period_locks');
    }
};


