<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_fifo_layers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            // Product reference
            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->integer('variation_id')->unsigned()->nullable();
            $table->foreign('variation_id')->references('id')->on('variations')->onDelete('cascade');
            $table->integer('location_id')->unsigned();
            $table->foreign('location_id')->references('id')->on('business_locations')->onDelete('cascade');
            
            // Purchase/transaction reference
            $table->integer('transaction_id')->unsigned()->nullable();
            $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('set null');
            $table->integer('transaction_line_id')->unsigned()->nullable();
            $table->date('layer_date')->comment('Date when this layer was created');
            
            // Layer details
            $table->decimal('quantity', 15, 4)->default(0)->comment('Available quantity in this layer');
            $table->decimal('unit_cost', 22, 4)->default(0)->comment('Cost per unit for this layer');
            $table->decimal('total_cost', 22, 4)->default(0)->comment('quantity * unit_cost');
            $table->decimal('allocated_quantity', 15, 4)->default(0)->comment('Quantity already allocated to sales');
            
            // Status
            $table->enum('status', ['available', 'fully_allocated', 'closed'])->default('available');
            
            $table->timestamps();
            
            // Indexes - using custom names to avoid MySQL 64-character limit
            $table->index(['business_id', 'product_id', 'variation_id', 'location_id', 'status'], 'ar_fifo_layers_main_idx');
            $table->index(['business_id', 'location_id', 'layer_date'], 'ar_fifo_layers_date_idx');
            $table->index(['business_id', 'transaction_id'], 'ar_fifo_layers_trans_idx');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_fifo_layers');
    }
};


