<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_ledger_rollups', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            $table->integer('account_id')->unsigned();
            $table->foreign('account_id')->references('id')->on('ar_chart_of_accounts')->onDelete('cascade');
            
            // Period aggregation
            $table->date('period_date')->comment('Last day of aggregation period (daily/monthly)');
            $table->enum('period_type', ['daily', 'monthly', 'yearly'])->default('daily');
            
            // Opening balance (at start of period)
            $table->decimal('opening_debit', 22, 4)->default(0);
            $table->decimal('opening_credit', 22, 4)->default(0);
            $table->decimal('opening_balance', 22, 4)->default(0)->comment('Dr - Cr (signed)');
            
            // Period movements
            $table->decimal('period_debit', 22, 4)->default(0);
            $table->decimal('period_credit', 22, 4)->default(0);
            
            // Closing balance (end of period)
            $table->decimal('closing_debit', 22, 4)->default(0);
            $table->decimal('closing_credit', 22, 4)->default(0);
            $table->decimal('closing_balance', 22, 4)->default(0)->comment('Dr - Cr (signed)');
            
            // Location scoping (optional)
            $table->integer('location_id')->unsigned()->nullable();
            $table->foreign('location_id')->references('id')->on('business_locations')->onDelete('set null');
            
            // Metadata
            $table->dateTime('computed_at');
            $table->timestamps();
            
            // Indexes for fast lookups - using custom names to avoid MySQL 64-character limit
            $table->unique(['business_id', 'account_id', 'period_date', 'period_type', 'location_id'], 'ar_ledger_rollup_unique');
            $table->index(['business_id', 'account_id', 'period_date'], 'ar_rollup_account_date_idx');
            $table->index(['business_id', 'period_date', 'period_type'], 'ar_rollup_period_idx');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_ledger_rollups');
    }
};


