<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_journal_entry_lines', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('journal_entry_id')->unsigned();
            $table->foreign('journal_entry_id')->references('id')->on('ar_journal_entry_headers')->onDelete('cascade');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            // Account reference
            $table->integer('account_id')->unsigned();
            $table->foreign('account_id')->references('id')->on('ar_chart_of_accounts')->onDelete('restrict');
            
            // Debit/Credit
            $table->decimal('debit', 22, 4)->default(0);
            $table->decimal('credit', 22, 4)->default(0);
            $table->decimal('amount', 22, 4)->comment('Absolute value (max of debit/credit)');
            
            // Reference details (for subledger reconciliation)
            $table->integer('contact_id')->unsigned()->nullable()->comment('Customer/Supplier for AR/AP');
            $table->foreign('contact_id')->references('id')->on('contacts')->onDelete('set null');
            
            $table->integer('product_id')->unsigned()->nullable()->comment('For inventory/COGS');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('set null');
            
            $table->integer('variation_id')->unsigned()->nullable();
            $table->foreign('variation_id')->references('id')->on('variations')->onDelete('set null');
            
            $table->integer('tax_id')->unsigned()->nullable();
            $table->foreign('tax_id')->references('id')->on('tax_rates')->onDelete('set null');
            
            // Description
            $table->text('description')->nullable();
            $table->string('reference', 255)->nullable();
            
            // For FIFO/COGS tracking
            $table->integer('fifo_layer_id')->unsigned()->nullable()->comment('Links to ar_fifo_layers if applicable');
            
            // Metadata
            $table->integer('line_number')->default(0);
            $table->timestamps();
            
            // Indexes - using custom names to avoid MySQL 64-character limit
            $table->index(['business_id', 'account_id'], 'ar_jel_account_idx');
            $table->index(['business_id', 'contact_id'], 'ar_jel_contact_idx');
            $table->index(['business_id', 'product_id'], 'ar_jel_product_idx');
            $table->index(['journal_entry_id', 'line_number'], 'ar_jel_entry_idx');
            $table->index(['business_id', 'account_id', 'created_at'], 'ar_jel_account_date_idx');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_journal_entry_lines');
    }
};


