<?php

return [
    'name' => 'AccountingReports',
    'module_version' => '1.0.3',
    
    // Aging buckets in days
    'aging_buckets' => [
        'current' => 0,
        'b0_7' => 7,
        'b8_30' => 30,
        'b31_60' => 60,
        'b61_90' => 90,
        'b90_plus' => 999999,
    ],
    
    // Costing method: 'fifo' or 'average'
    'costing_method' => env('ACCOUNTING_COSTING_METHOD', 'fifo'),
    
    // Currency symbol for reports
    'currency_symbol' => env('ACCOUNTING_CURRENCY_SYMBOL', 'Rs'),
    
    // Default account groups for Chart of Accounts
    'account_groups' => [
        'assets_current' => 'Current Assets',
        'assets_non_current' => 'Non-Current Assets',
        'liabilities_current' => 'Current Liabilities',
        'liabilities_non_current' => 'Non-Current Liabilities',
        'equity' => 'Equity',
        'income' => 'Income',
        'cogs' => 'Cost of Goods Sold',
        'expenses' => 'Expenses',
        'other_income' => 'Other Income',
        'other_expenses' => 'Other Expenses',
    ],
    
    // Financial ratios formulas
    'ratios' => [
        'current_ratio' => 'current_assets / current_liabilities',
        'quick_ratio' => '(current_assets - inventory) / current_liabilities',
        'debt_to_equity' => 'total_debt / total_equity',
        'interest_coverage' => 'operating_profit / interest_expense',
        'gross_margin' => '(revenue - cogs) / revenue * 100',
        'operating_margin' => 'operating_profit / revenue * 100',
        'net_margin' => 'net_profit / revenue * 100',
        'roa' => 'net_profit / total_assets * 100',
        'roe' => 'net_profit / total_equity * 100',
    ],
    
    // Period locking (prevent edits after period end)
    'enable_period_lock' => env('ACCOUNTING_ENABLE_PERIOD_LOCK', false),
    
    // Performance settings
    'chunk_size' => env('ACCOUNTING_CHUNK_SIZE', 1000),
    'enable_materialized_ledgers' => env('ACCOUNTING_MATERIALIZED_LEDGERS', true),
];


