<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header no-print">
            <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span
                    aria-hidden="true">×</span></button>
            <h4 class="modal-title no-print">
                Journal Entry </h4>
        </div>
        {{-- @dd($journal); --}}
        <div class="modal-body">

            <table style="width:100%;">
                <thead>
                    <tr>
                        <td>
                            <p class="text-left">
                                <br>
                                Name of the business location: {{ $journal->business_name ?? '' }}
                                <br>

                                <br>
                                Mobile:
                            </p>
                            <hr>
                        </td>
                    </tr>
                </thead>
            </table>

            <table style="width:100%;" class="table cf table-hover">
                <thead class="cf">
                    <tr>
                        <th colspan="1">Journal Type Journal Entry</th>
                        <th colspan="2">
                            Sells Invoice</th>
                        <th>Ref. Number {{ $journal->ref_no ?? '' }}</th>
                        <th>Date {{ $journal->operation_date ?? '' }}</th>
                    </tr>
                    <tr>
                        <th class="journal-report-align-cols" style="width: 30%;">Account</th>
                        <th class="journal-report-align-cols">Detail</th>
                        <th class="journal-report-align-cols">Debit</th>
                        <th class="journal-report-align-cols">Credit</th>
                        <th class="journal-report-align-cols">Suspend Note</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $debitTotal = $journal->transactions->where('type', 'debit')->sum('amount');
                        $creditTotal = $journal->transactions->where('type', 'credit')->sum('amount');
                    @endphp
                    @foreach ($journal->transactions as $transaction)
                        <tr>
                            <td>{{ $transaction->account_number ?? 'N/A' }} '-'
                                {{ $transaction->account_name ?? 'N/A' }}</td>
                            <td>{{ $transaction->note ?? 'N/A' }}</td>
                          
                            <td>{{ $transaction->type === 'debit' ? $transaction->amount : '' }}</td>
                            <td>{{ $transaction->type === 'credit' ? $transaction->amount : '' }}</td>
                            <td colspan="2">{{ $transaction->account_description ?? '' }}</td>
                        </tr>
                    @endforeach


                    <tr class="reports-total">
                        <td data-title="Account">Created By {{ $journal->added_by ?? '' }} </td>
                        <td data-title="Contact"></td>
                        <td data-title="Debit">{{ number_format($debitTotal, 2) }}</td>
                        <td data-title="Credit">{{ number_format($creditTotal, 2) }}</td>
                        <td data-title="comment" colspan="2"></td>
                    </tr>
                    <tr>
                        <td colspan="6">Payment Note {{ $journal->note ?? '' }}</td>
                    </tr>
                </tbody>
            </table>


        </div>
        <div class="modal-footer no-print">
            <button type="button" class="btn btn-primary no-print" aria-label="Print"
                onclick="$(this).closest('div.modal').printThis();">
                <i class="fa fa-print"></i> Print </button>
            <button type="button" class="btn btn-default no-print" data-dismiss="modal">Close </button>
        </div>
    </div>
</div>
