@extends('layouts.app')

@section('title', __('accounting::lang.journal_entry'))

@section('content')

    @include('accounting::layouts.nav')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('accounting::lang.journal_entry')</h1>
    </section>
    <section class="content no-print">
        <div class="row">
            <div class="col-md-12">
                @component('components.filters', ['title' => __('report.filters')])
                    <div class="col-md-4">
                        <div class="form-group">
                            {!! Form::label('journal_entry_date_range_filter', __('report.date_range') . ':') !!}
                            {!! Form::text('journal_entry_date_range_filter', null, [
                                'placeholder' => __('lang_v1.select_a_date_range'),
                                'class' => 'form-control',
                                'readonly',
                            ]) !!}
                        </div>
                    </div>
                @endcomponent
            </div>
        </div>
        {{-- @component('components.widget', ['class' => 'box-solid'])
            @can('accounting.add_journal')
                @slot('tool')
                    <div class="box-tools">
                        <a style="border-radius: 0; background-color: #FFB600"
                            class="tw-dw-btn tw-font-bold tw-text-white tw-border-none pull-right"
                            href="{{ action([\Modules\Accounting\Http\Controllers\JournalEntryController::class, 'create']) }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M12 5l0 14" />
                                <path d="M5 12l14 0" />
                            </svg> @lang('messages.add')
                        </a>
                    </div>
                @endslot
            @endcan

            <table class="table table-bordered table-striped" id="journal_table">
                <thead>
                    <tr>
                        <th>@lang('messages.action')</th>
                        <th>@lang('accounting::lang.journal_date')</th>
                        <th>@lang('purchase.ref_no')</th>
                        <th>@lang('lang_v1.added_by')</th>
                        <th>@lang('lang_v1.additional_notes')</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        @endcomponent --}}

        <!--single item-->
        <div
            class="box-solid tw-mb-4 tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw-translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-2 sm:tw-p-3">
                <div class="tw-flow-root tw-border-gray-200">
                    <div>
                        <div class="tw-py-2 tw-align-middle sm:tw-px-5">
                            <div class="row" style="margin-bottom: 5px;">
                                <div class="col-md-4">
                                    <a class="btn btn-block btn-primary" href="{{ route('journal-entry.create') }}">
                                        <i class="fas fa-plus"></i> Add Journal</a>
                                </div>
                                <div class="col-md-4">
                                    <button type="button" class="btn btn-block btn-primary btn-modal openingBalance"
                                        {{-- data-href="{{ route('accounting.create.opening-balance1') }}" --}} {{-- data-container="#create_opening_balance_modal" --}}>
                                        <i class="fas fa-plus"></i> Add Opening balance debit</button>
                                </div>
                                <div class="col-md-4">
                                    <button type="button" class="btn btn-block btn-primary btn-modal openingBalanceCredit"
                                        {{-- data-href="{{ 'accounting.create.opening-balance2' }}" --}} {{-- data-container="#create_opening_balance_modal" --}}>
                                        <i class="fas fa-plus"></i> Add Opening balance credit</button>
                                </div>
                            </div>

                            <div class="row" style="margin-bottom: 5px;">
                                <div class="col-md-6">
                                    <a class="btn btn-block btn-primary" href="{{ route('accounting.create.reciept') }}">
                                        <i class="fas fa-plus"></i> accounting Receipt</a>
                                </div>
                                <div class="col-md-6">
                                    <a class="btn btn-block btn-primary" href="{{ route('accounting.create.expense') }}">
                                        <i class="fas fa-plus"></i>Expense</a>
                                </div>
                            </div>
                            <div id="journal_entries"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!---single item end-->

        <nav>
            <ul class="pagination" id="pagination">
                <!-- Pagination buttons will be added dynamically -->
            </ul>
        </nav>



        <!--Add Opening Balance debit Model--->
        <div class="modal fade" id="create_opening_balance_modal" tabindex="-1" role="dialog" style="display: none;">
            <div class="modal-dialog" role="document">
                <div class="modal-content">

                    <form method="POST" action="{{ route('accounting.store.opening-balance-debit') }}"
                        accept-charset="UTF-8" id="opening_balance_form" novalidate="novalidate"><input name="_token"
                            type="hidden">
                        @csrf

                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                    aria-hidden="true">×</span></button>
                            <h4 class="modal-title">Add Opening balance debit</h4>
                        </div>

                        <div class="modal-body">

                            <div class="form-group">
                                {!! Form::label('opening_balance_account', __('Opening Balance Account') . ':*') !!}
                                {!! Form::select('opening_balance_account', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}

                            </div>

                            <div class="form-group">
                                {!! Form::label('user_accounts', __('User Account') . ':*') !!}
                                {!! Form::select('user_accounts', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}
                            </div>



                            <div class="form-group">
                                {!! Form::label('opening_balance', __('Opening balance') . ':*') !!}
                                {!! Form::text('opening_balance', 0, ['class' => 'form-control']) !!}
                            </div>



                            <div class="form-group">
                                {!! Form::label('date', __('Date') . ':*') !!}
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                    {!! Form::text('date', @format_datetime('now'), [
                                        'class' => 'form-control datetimepicker',
                                        'readonly',
                                        'required',
                                    ]) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="note">Note</label>
                                <textarea class="form-control" placeholder="Note" rows="4" name="note" cols="50" id="note"></textarea>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save</button>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>

                    </form>

                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!--Add Opening Balance debit Model end--->


        <!--edit Opening Balance debit Model create--->
        <div class="modal fade" id="edit_opening_balance_modal" tabindex="-1" role="dialog" style="display: none;">
            <div class="modal-dialog" role="document">
                <div class="modal-content">

                    <form method="POST" id="edit_opening_balance_form" action="" accept-charset="UTF-8"
                        id="opening_balance_form" novalidate="novalidate"><input name="_token" type="hidden">
                        @csrf

                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                    aria-hidden="true">×</span></button>
                            <h4 class="modal-title">Edit Opening balance debit</h4>
                        </div>

                        <div class="modal-body">

                            <div class="form-group">
                                {!! Form::label('opening_balance_account', __('Opening Balance Account') . ':*') !!}
                                {!! Form::select('opening_balance_account', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}

                            </div>

                            <div class="form-group">
                                {!! Form::label('user_accounts', __('User Account') . ':*') !!}
                                {!! Form::select('user_accounts', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}
                            </div>



                            <div class="form-group">
                                {!! Form::label('opening_balance', __('Opening balance') . ':*') !!}
                                {!! Form::text('opening_balance', 0, ['class' => 'form-control']) !!}
                            </div>



                            <div class="form-group">
                                {!! Form::label('date', __('Date') . ':*') !!}
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                    {!! Form::text('date', @format_datetime('now'), [
                                        'class' => 'form-control datetimepicker',
                                        'readonly',
                                        'required',
                                    ]) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="note">Note</label>
                                <textarea class="form-control" placeholder="Note" rows="4" name="note" cols="50" id="note"></textarea>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save</button>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>

                    </form>

                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!--edit Opening Balance debit Model edit--->



        <!--Add Opening Balance credit Model--->
        <div class="modal fade" id="create_opening_balance_credit_modal" tabindex="-1" role="dialog"
            style="display: none;">
            <div class="modal-dialog" role="document">
                <div class="modal-content">

                    <form method="POST" action="{{ route('accounting.store.opening-balance-credit') }}"
                        accept-charset="UTF-8" id="opening_balance_form" novalidate="novalidate"><input name="_token"
                            type="hidden">
                        @csrf

                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                    aria-hidden="true">×</span></button>
                            <h4 class="modal-title">Add Opening balance Credit</h4>
                        </div>

                        <div class="modal-body">


                            <div class="form-group">
                                {!! Form::label('user_accounts', __('U. Account') . ':*') !!}
                                {!! Form::select('user_accounts', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}
                            </div>

                            <div class="form-group">
                                {!! Form::label('opening_balance_account', __('Opening Balance Account') . ':*') !!}
                                {!! Form::select('opening_balance_account', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}

                            </div>




                            <div class="form-group">
                                {!! Form::label('opening_balance', __('Opening balance') . ':*') !!}
                                {!! Form::text('opening_balance', 0, ['class' => 'form-control']) !!}
                            </div>



                            <div class="form-group">
                                {!! Form::label('date', __('Date') . ':*') !!}
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                    {!! Form::text('date', @format_datetime('now'), [
                                        'class' => 'form-control datetimepicker',
                                        'readonly',
                                        'required',
                                    ]) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="note">Note</label>
                                <textarea class="form-control" placeholder="Note" rows="4" name="note" cols="50" id="note"></textarea>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save</button>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>

                    </form>

                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <!--Add Opening Balance credit Model end--->


        <!--edit Opening Balance credit Model--->
        <div class="modal fade" id="edit_opening_balance_credit_modal" tabindex="-1" role="dialog"
            style="display: none;">
            <div class="modal-dialog" role="document">
                <div class="modal-content">

                    <form method="POST" id="edit_opening_balance_credit_form" action=""
                        accept-charset="UTF-8" novalidate="novalidate">
                        @csrf
                        <input type="hidden" name="id" id="edit_ob_credit_id">

                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span></button>
                            <h4 class="modal-title">Edit Opening Balance Credit</h4>
                        </div>

                        <div class="modal-body">

                            <div class="form-group">
                                {!! Form::label('edit_user_accounts', __('U. Account') . ':*') !!}
                                {!! Form::select('user_accounts', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'id' => 'edit_user_accounts',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}
                            </div>

                            <div class="form-group">
                                {!! Form::label('edit_opening_balance_account', __('Opening Balance Account') . ':*') !!}
                                {!! Form::select('opening_balance_account', [], null, [
                                    'class' => 'form-control accounts-dropdown account_id',
                                    'id' => 'edit_opening_balance_account',
                                    'placeholder' => __('messages.please_select'),
                                    'style' => 'width: 100%;',
                                ]) !!}
                            </div>

                            <div class="form-group">
                                {!! Form::label('edit_opening_balance', __('Opening balance') . ':*') !!}
                                {!! Form::text('opening_balance', 0, [
                                    'class' => 'form-control',
                                    'id' => 'edit_opening_balance',
                                ]) !!}
                            </div>

                            <div class="form-group">
                                {!! Form::label('edit_date', __('Date') . ':*') !!}
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                    {!! Form::text('date', null, [
                                        'class' => 'form-control datetimepicker',
                                        'readonly',
                                        'required',
                                        'id' => 'edit_date',
                                    ]) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="edit_note">Note</label>
                                <textarea class="form-control" placeholder="Note" rows="4" name="note" cols="50" id="edit_note"></textarea>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Update</button>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>

                    </form>

                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>

        <!--edit Opening Balance credit Model end--->


    </section>

@stop

@section('javascript')
    @include('accounting::accounting.common_js')
    <script type="text/javascript">
        $(document).ready(function() {
            function loadJournalEntries(page = 1, start_date = '', end_date = '') {
                $.ajax({
                    url: '/accounting/journal-entry?page=' + page,
                    type: 'GET',
                    data: {
                        start_date: start_date,
                        end_date: end_date
                    },
                    dataType: 'json',
                    success: function(response) {
                        console.log("response", response);
                        let tables = '';
                        response.data.forEach(function(entry) {
                            tables += `
                        <div class="table-responsive manage-currency-table reports-table">
                            <table class="table cf table-hover">
                                <thead class="cf">
                                    <tr style="background-color: #1572e8 !important;color: white !important">
                                        <th colspan="1">Journal Type ${entry?.type}</th>
                                        <th colspan="2">Sells Invoice ${entry.ref_no}</th>
                                        <th>Registration Number JE${entry.id}</th>
                                        <th>Date ${entry.operation_date}</th>
                                        <th style="text-align: end;">
                                            <a href="#" class="btn-modal" data-href="/accounting/print-journal-entry/${entry.id}" data-container=".view_modal">
                                                <i style="color: white !important" class="fa fa-print fa-lg" data-toggle="tooltip" data-placement="bottom" title="Print"></i>
                                            </a>
                                            ${entry.type === 'opening_balance_debit' ? `
                                                <a href="#" class="editOpeningBalance"
                                                data-id="${entry.id}"
                                                data-opening_balance_account="${entry?.transactions[0]?.accounting_account_id}"
                                                data-opening_balance_name="${entry?.transactions[0]?.account_name}"
                                                data-user_account="${entry?.transactions[1]?.accounting_account_id}"
                                                data-user_account_name="${entry?.transactions[1]?.account_name}"
                                                data-opening_balance="${entry?.transactions[0]?.amount}"
                                                data-date="${entry?.transactions[0]?.operation_date}"
                                                data-note="${entry?.transactions[0]?.note}">
                                                    <i style="color: white !important" class="fas fa-edit fa-lg"
                                                    data-toggle="tooltip" data-placement="bottom" title="Edit"></i>
                                                </a>
                                            ` :
                                        (entry?.type === 'opening_balance_credit' ? `
                                            <a href="#" class="editOpeningBalanceCredit"
                                                data-id="${entry.id}"
                                                data-opening_balance_account="${entry?.transactions[1]?.accounting_account_id}"
                                                data-opening_balance_name="${entry?.transactions[1]?.account_name}"
                                                data-user_account="${entry?.transactions[0]?.accounting_account_id}"
                                                data-user_account_name="${entry?.transactions[0]?.account_name}"
                                                data-opening_balance="${entry?.transactions[0]?.amount}"
                                                data-date="${entry?.transactions[0]?.operation_date}"
                                                data-note="${entry?.transactions[0]?.note}">
                                                    <i style="color: white !important" class="fas fa-edit fa-lg"
                                                    data-toggle="tooltip" data-placement="bottom" title="Edit"></i>
                                                </a>
                                            ` : 
                                        `  <a href="/accounting/journal-entry/${entry.id}/edit">
                                                                <i style="color: white !important" class="fas fa-edit fa-lg" data-toggle="tooltip" data-placement="bottom" title="Edit"></i>
                                                            </a>`
                                    )
                                        }
                                          
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="journal-report-align-cols" style="width: 30%;">Account</th>
                                        <th class="journal-report-align-cols">Detail</th>
                                        <th class="journal-report-align-cols">Debit</th>
                                        <th class="journal-report-align-cols">Credit</th>
                                        <th class="journal-report-align-cols" colspan="2">Suspend Note</th>
                                    </tr>
                                </thead>
                                <tbody>
                                     ${entry.transactions.map(transaction => `
                                            <tr>
                                                  <td>${transaction.account_number || transaction?.gl_code || 'N/A'} - ${transaction.account_name} </td>
                                                <td>${transaction?.note || ''}</td>
                                                <td>${transaction.type === 'debit' ?  parseFloat(transaction.amount).toFixed(2) : ''}</td>
                                                <td>${transaction.type === 'credit' ?  parseFloat(transaction.amount).toFixed(2) : ''}</td>
                                                <td colspan="2">${transaction?.account_description || ''}</td>
                                            </tr>
                                        `).join('')}
                                   
                                    
                                   <tr class="reports-total">
        <td data-title="Account">Created By ${entry.added_by}</td>
        <td data-title="Contact"></td>
        <td data-title="Debit">${entry.transactions.reduce((sum, t) => t.type === 'debit' ? sum + parseFloat(t.amount) : sum, 0).toFixed(2)}</td>
        <td data-title="Credit">${entry.transactions.reduce((sum, t) => t.type === 'credit' ? sum + parseFloat(t.amount) : sum, 0).toFixed(2)}</td>
        <td data-title="comment" colspan="2"></td>
    </tr>
                                    <tr style="background-color: #1572e8 !important;color: white !important">
                                        <td colspan="6">Payment Note : ${entry?.note}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    `;
                        });

                        $('#journal_entries').html(tables);

                        // Pagination
                        let paginationLinks = '';
                        if (response.prev_page_url) {
                            paginationLinks +=
                                `<li class="page-item"><a class="page-link" href="#" data-page="${response.current_page - 1}">Previous</a></li>`;
                        }
                        for (let i = 1; i <= response.last_page; i++) {
                            let activeClass = (i === response.current_page) ? 'active' : '';
                            paginationLinks +=
                                `<li class="page-item ${activeClass}"><a class="page-link" href="#" data-page="${i}">${i}</a></li>`;
                        }
                        if (response.next_page_url) {
                            paginationLinks +=
                                `<li class="page-item"><a class="page-link" href="#" data-page="${response.current_page + 1}">Next</a></li>`;
                        }
                        $('#pagination').html(paginationLinks);
                    },
                    error: function(error) {
                        console.log('Error fetching journal entries:', error);
                    }
                });
            }

            // Load journal entries on page load
            loadJournalEntries();

            // Handle Pagination Clicks
            $(document).on('click', '.page-link', function(e) {
                e.preventDefault();
                let page = $(this).data('page');
                loadJournalEntries(page);
            });
        });


        $(document).on("click", ".openingBalance", function() {
            $("#create_opening_balance_modal").modal("show");
        })


        function setSelectValue(selectName, value, text = null) {
            const $select = $(`#edit_opening_balance_modal select[name="${selectName}"]`);

            // Check if value exists
            if ($select.find(`option[value="${value}"]`).length === 0) {
                // If not, append a new option (useful if options are not loaded yet)
                $select.append(new Option(text ?? value, value, true, true));
            }

            $select.val(value).trigger('change');
        }
        $(document).on("click", ".editOpeningBalance", function(e) {
            e.preventDefault();

            let id = $(this).data("id");

            $("#edit_opening_balance_form").attr("action", `/accounting/opening_balance_debit/update/${id}`);


            setSelectValue('opening_balance_account', $(this).data("opening_balance_account"), $(this).data(
                "opening_balance_name") ?? 'Opening Balance');
            setSelectValue('user_accounts', $(this).data("user_account"), $(this).data("user_account_name") ??
                'user account name');
            $("#edit_opening_balance_modal input[name='opening_balance']").val($(this).data("opening_balance"));
            $("#edit_opening_balance_modal input[name='date']").val($(this).data("date"));
            $("#edit_opening_balance_modal textarea[name='note']").val($(this).data("note"));


            $(".modal-title").text("Edit Opening Balance Debit");
            // $(".btn-primary").text("Update");


            $("#edit_opening_balance_modal").modal("show");
        });


        $(document).on("click", ".openingBalanceCredit", function() {
            $("#create_opening_balance_credit_modal").modal("show");
        })




        function setSelectValueOpeningCredit(selectName, value, text = null) {
            const $select = $(`#edit_opening_balance_credit_modal select[name="${selectName}"]`);

            // Check if value exists
            if ($select.find(`option[value="${value}"]`).length === 0) {
                // If not, append a new option (useful if options are not loaded yet)
                $select.append(new Option(text ?? value, value, true, true));
            }

            $select.val(value).trigger('change');
        }

        $(document).on("click", ".editOpeningBalanceCredit", function(e) {
            e.preventDefault();

            let id = $(this).data("id");
            $("#edit_opening_balance_credit_modal #edit_ob_credit_id").val(id);

            $("#edit_opening_balance_credit_form").attr("action", `/accounting/opening-balance-credit/update/${id}`);


            setSelectValueOpeningCredit('opening_balance_account', $(this).data("opening_balance_account"), $(this).data(
                "opening_balance_name") ?? 'Opening Balance');
                setSelectValueOpeningCredit('user_accounts', $(this).data("user_account"), $(this).data("user_account_name") ??
                'user account name');
            $("#edit_opening_balance_credit_modal input[name='opening_balance']").val($(this).data("opening_balance"));
            $("#edit_opening_balance_credit_modal input[name='date']").val($(this).data("date"));
            $("#edit_opening_balance_credit_modal textarea[name='note']").val($(this).data("note"));


            $("#edit_opening_balance_credit_modal .modal-title").text("Edit Opening Balance Credit");
            // $(".btn-primary").text("Update");


            $("#edit_opening_balance_credit_modal").modal("show");
        })
    </script>
@endsection
