@extends('layouts.app')

@section('title', __('accounting::lang.edit_receipt'))

@section('content')

    @include('accounting::layouts.nav')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
            @lang('Edit Receipt')
        </h1>
    </section>

    <section class="content">
        {!! Form::open([
            'url' => action([\Modules\Accounting\Http\Controllers\JournalEntryController::class, 'updateReceipt'], $journal->id),
            'method' => 'put', // Use PUT for updates
            'id' => 'receipt_edit_form',
        ]) !!}

        <!-- Hidden field for receipt ID -->
        {!! Form::hidden('id', $journal->id) !!}

        @component('components.widget', ['class' => 'box-primary'])
            <div class="row">

                <!-- User Account -->
                <div class="form-group">
                    {!! Form::label('user_account', __('User Account') . ':*') !!}
                    {!! Form::select('user_account_id', $accounts, $user_account->id ?? null, [
                        'class' => 'form-control accounts-dropdown user_account',
                        'placeholder' => __('messages.please_select'),
                        'style' => 'width: 100%;',
                    ]) !!}
                </div>

                <!-- Payment Method -->
                <div class="form-group">
                    {!! Form::label('payment_method', __('Payment Method') . ':*') !!}
                    {!! Form::select('payment_method_id', $paymentMethods, $payment_method->id ?? null, [
                        'class' => 'form-control accounts-dropdown payment_method',
                        'placeholder' => __('messages.please_select'),
                        'style' => 'width: 100%;',
                    ]) !!}
                </div>

                <!-- Amount -->
                <div class="form-group">
                    {!! Form::label('amount', __('amount') . ':*') !!}
                    {!! Form::text('amount', $amount, ['class' => 'form-control input_number']) !!}
                </div>

                <!-- Journal Date -->
                <div class="form-group">
                    {!! Form::label('journal_date', __('accounting::lang.journal_date') . ':*') !!}
                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </span>
                        {!! Form::text('journal_date', @format_datetime($journal_date), [
                            'class' => 'form-control datetimepicker',
                            'readonly',
                            'required',
                        ]) !!}
                    </div>
                </div>

                <!-- Note -->
                <div class="form-group">
                    {!! Form::label('note', __('Note')) !!}
                    {!! Form::textarea('note', $note, ['class' => 'form-control', 'rows' => 3]) !!}
                </div>

                <!-- Save Button -->
                <div class="form-group text-center">
                    <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right">
                        @lang('messages.update')
                    </button>
                </div>

            </div>
        @endcomponent

        {!! Form::close() !!}
    </section>

@stop

@section('javascript')
    @include('accounting::accounting.common_js')
    <script type="text/javascript">
        $(document).ready(function() {
            // Initialize datetime picker
            $('.datetimepicker').datetimepicker({
                format: 'YYYY-MM-DD HH:mm:ss',
                sideBySide: true,
            });

            // Initialize Select2 for dropdowns
            $('.accounts-dropdown').select2({
                ajax: {
                    url: '{{ route('accounts-dropdown') }}',
                    dataType: 'json',
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                },
                escapeMarkup: function(markup) {
                    return markup;
                },
                templateResult: function(data) {
                    return data.html;
                },
                templateSelection: function(data) {
                    return data.text;
                }
            });
        });
    </script>
@endsection