@extends('layouts.app')

@section('title', __('accounting::lang.journal_entry'))

@section('content')

    @include('accounting::layouts.nav')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('Edit Expense')</h1>
    </section>
    <section class="content">

        {!! Form::open([
            'url' => action([\Modules\Accounting\Http\Controllers\JournalEntryController::class, 'updateExpense']),
            'method' => 'post',
            'id' => 'journal_edit_form',
        ]) !!}
        {!! Form::hidden('id', $journal_entry->id) !!}

        @component('components.widget', ['class' => 'box-primary'])
            <div class="row">

                <div class="form-group">
                    {!! Form::label('ref_no', __('purchase.ref_no') . ':') !!}
                    {!! Form::text('ref_no', $journal_entry->ref_no, ['class' => 'form-control']) !!}
                </div>

                <div class="form-group">
                    {!! Form::label('payment_method', __('Payment Method') . ':*') !!}
                    {!! Form::select('payment_method', $accounts, optional($journal_entry->transactions->firstWhere('type', 'credit'))->accounting_account_id,
                    ['class' => 'form-control accounts-dropdown payment_method', 
                    'placeholder' => __('messages.please_select'), 'style' => 'width: 100%;']); !!}
                </div>

                <div class="form-group">
                    {!! Form::label('expense_account_for', __('Expense Account For') . ':*') !!}
                    {!! Form::select('expense_account_for', $accounts, optional($journal_entry->transactions->firstWhere('type', 'debit'))->accounting_account_id, 
                    ['class' => 'form-control accounts-dropdown account_id', 
                    'placeholder' => __('messages.please_select'), 'style' => 'width: 100%;']); !!}
                </div>

                <div class="form-group">
                    {!! Form::label('amount', __('amount') . ':*') !!}
                    {!! Form::text('amount', optional($journal_entry->transactions->first())->amount, ['class' => 'form-control']) !!}
                </div>

                <div class="form-group">
                    {!! Form::label('journal_date', __('accounting::lang.journal_date') . ':*') !!}
                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </span>
                        {!! Form::text('journal_date', @format_datetime($journal_entry->operation_date), [
                            'class' => 'form-control datetimepicker',
                            'readonly',
                            'required',
                        ]) !!}
                    </div>
                </div>

                <div class="form-group">
                    {!! Form::label('note', __('Note')) !!}
                    {!! Form::textarea('note', $journal_entry->note, ['class' => 'form-control', 'rows' => 3]); !!}
                </div>

                <div class="form-group text-center">
                    <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white pull-right">@lang('messages.update')</button>
                </div>

            </div>
        @endcomponent

        {!! Form::close() !!}
    </section>

@stop

@section('javascript')
    @include('accounting::accounting.common_js')
    <script>
        $(document).ready(function() {
            $('.accounts-dropdown').select2();
        });
    </script>
@endsection
