# License System - Quick Setup Guide

**For BusinessManagement Module**

---

## 🚀 Setup Steps (5 Minutes)

### Step 1: Run Database Migration

```bash
php artisan migrate
```

This creates the `module_licenses` table.

---

### Step 2: Update License Configuration

Edit: `Modules/BusinessManagement/Config/config.php`

```php
return [
    'name' => 'BusinessManagement',
    'module_version' => '1.0.1',
    'pid' => 999, // ⚠️ UPDATE: Your actual product ID
    'lic1' => 'YOUR_BASE64_ENCODED_URL', // ⚠️ UPDATE: Your license validation URL
    'lic2' => 'YOUR_BASE64_ENCODED_URL', // ⚠️ UPDATE: Backup URL
];
```

**To encode URL:**
```php
echo base64_encode('https://your-license-server.com/api/validate');
```

---

### Step 3: Generate a Test License

**Option A: Via Admin Panel**
1. Login as superadmin
2. Go to: `http://your-domain.com/license-management`
3. Fill form and generate license

**Option B: Via Command Line**
```bash
php artisan license:generate businessmanagement testuser test@example.com --type=single
```

**Copy the generated license code!**

---

### Step 4: Test Installation

1. Go to module installation page
2. Enter:
   - License Code: (from step 3)
   - Username: testuser
3. Click "I Agree, SUBMIT"
4. ✅ Should install successfully

---

## ✅ Verification

### Check License Table
```sql
SELECT * FROM module_licenses;
```

### Check License is Stored
```php
// After installation
System::getProperty('businessmanagement_license_code');
```

---

## 🎯 That's It!

The license system is now active. Users **cannot install** the module without a valid license.

---

## 📞 Support

If you need help:
1. Check `LICENSE_SYSTEM_COMPLETE.md` for full documentation
2. Check `LICENSE_SYSTEM_IMPLEMENTATION.md` for technical details

---

**Status:** ✅ **READY TO USE**

