# License API Endpoint Setup Guide

## Current Status

**Issue:** The license validation API endpoint at `https://dev.posifyme.com/api/validate` returns 404 (Not Found).

## Step-by-Step Solution

### Step 1: Contact Posify for API Endpoint

Since the API endpoint doesn't exist yet, you need to:

1. **Contact Posify Support:**
   - Website: [www.posifyme.com](https://www.posifyme.com)
   - WhatsApp: +8801675444143
   - Ask them for:
     - The correct API endpoint URL for license validation
     - The expected request format (POST data fields)
     - The expected response format (JSON structure)
     - Any authentication requirements (API keys, tokens, etc.)

### Step 2: Update Configuration Once You Have the Endpoint

Once you receive the correct endpoint URL, update the configuration:

**File:** `Modules/BusinessManagement/Config/config.php`

```php
<?php

return [
    'name' => 'BusinessManagement',
    'module_version' => '1.0.1',
    'pid' => 25, // Product ID for BusinessManagement module
    'lic1' => 'BASE64_ENCODED_URL_HERE', // Replace with actual endpoint
    'lic2' => 'BACKUP_URL_HERE', // Optional backup endpoint
];
```

**To encode the URL:**
```bash
php -r "echo base64_encode('https://dev.posifyme.com/YOUR_ENDPOINT_HERE');"
```

### Step 3: Test the Endpoint

Use the test script to verify the endpoint works:

```bash
php test_endpoints.php
```

Or manually test with:
```bash
php -r "
\$ch = curl_init('YOUR_ENDPOINT_URL');
curl_setopt_array(\$ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS => http_build_query([
        'license_code' => 'TEST',
        'username' => 'test',
        'product_id' => 25
    ])
]);
\$response = curl_exec(\$ch);
\$code = curl_getinfo(\$ch, CURLINFO_HTTP_CODE);
echo 'HTTP Code: ' . \$code . PHP_EOL;
echo 'Response: ' . \$response . PHP_EOL;
"
```

### Step 4: Temporary Solution - Use Local License Validation

Until the API endpoint is set up, you can use **local license validation**:

1. **Run the migration** to create the licenses table:
   ```bash
   php artisan migrate
   ```

2. **Generate a license** using the License Management system:
   - Go to: `/license-management` (as superadmin)
   - Generate a license for the BusinessManagement module
   - Use that license code and username during installation

3. **The system will automatically:**
   - First check local database for the license
   - If found and valid, proceed with installation
   - If not found, try remote validation (which will fail with 404)
   - Show helpful error message

### Step 5: Verify Installation Works

1. Try installing the module with a locally generated license
2. Check logs at `storage/logs/laravel.log` for any errors
3. If successful, the module will install

## Expected API Response Format

The system expects one of these response formats:

### Format 1 (Preferred):
```json
{
    "flag": "valid",
    "msg": "License is valid"
}
```

### Format 2:
```json
{
    "status": "valid",
    "message": "License is valid"
}
```

### Format 3:
```json
{
    "valid": true,
    "message": "License is valid"
}
```

### Format 4:
```json
{
    "success": true,
    "message": "License is valid"
}
```

## Troubleshooting

### Error: "License validation endpoint not found (404)"
- **Solution:** The API endpoint doesn't exist. Contact Posify to set it up or use local validation.

### Error: "Invalid response format from license server"
- **Solution:** The API is returning HTML or non-JSON. Check the endpoint URL and server configuration.

### Error: "Unable to connect to license server"
- **Solution:** Check internet connection, firewall settings, or server availability.

## Next Steps

1. ✅ Contact Posify for the correct API endpoint
2. ⏳ Update `config.php` with the correct endpoint
3. ⏳ Test the endpoint
4. ⏳ Verify installation works
5. ⏳ Update documentation with the correct endpoint

