@extends('layouts.app')
@section('title', 'Date wise Net Product Sales')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Date wise Net Product Sales</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseNetProductSales']), 'method' => 'get', 'id' => 'date_wise_net_product_sales_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_wise_net_product_sales_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', 'Product Filter' . ':') !!}
                        {!! Form::select('product_filter', ['all' => 'All Product', 'single' => 'Single Product'], 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('product_id', 'Product' . ':') !!}
                        {!! Form::select('product_id', $products, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => 'Select Product', 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', 'Category Filter' . ':') !!}
                        {!! Form::select('category_filter', ['all' => 'All Category', 'single' => 'Single Category'], 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('category_id', 'Category' . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => 'Select Category', 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="date_wise_net_product_sales_table">
                        <thead>
                            <tr>
                                <th>Product Description</th>
                                <th>Sale Qty</th>
                                <th>Unit Price</th>
                                <th>Sales Amount</th>
                                <th>Return Qty</th>
                                <th>Return Price</th>
                                <th>Return Amount</th>
                                <th>Net Qty</th>
                                <th>Net Amount</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('#date_wise_net_product_sales_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#date_wise_net_product_sales_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
            }
        );

        $('#date_wise_net_product_sales_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val('').trigger('change');
            }
        });

        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val('').trigger('change');
            }
        });

        var table = $('#date_wise_net_product_sales_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "dateWiseNetProductSales"]) }}',
                data: function(d) {
                    d.product_id = $('#product_filter').val() == 'single' ? $('#product_id').val() : '';
                    d.category_id = $('#category_filter').val() == 'single' ? $('#category_id').val() : '';
                    if ($('#date_wise_net_product_sales_date_range').val()) {
                        var start = $('#date_wise_net_product_sales_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#date_wise_net_product_sales_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'product_description', name: 'product_description' },
                { data: 'sale_qty', name: 'sale_qty' },
                { data: 'unit_price', name: 'unit_price' },
                { data: 'sales_amount', name: 'sales_amount' },
                { data: 'return_qty', name: 'return_qty' },
                { data: 'return_price', name: 'return_price' },
                { data: 'return_amount', name: 'return_amount' },
                { data: 'net_qty', name: 'net_qty' },
                { data: 'net_amount', name: 'net_amount' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#date_wise_net_product_sales_table'));
            },
        });

        $('#apply_filters').on('click', function() {
            table.ajax.reload();
            checkPrintButton();
        });

        $('#reset_filters').on('click', function() {
            $('#product_filter').val('all').trigger('change');
            $('#category_filter').val('all').trigger('change');
            $('#product_id').val('').trigger('change');
            $('#category_id').val('').trigger('change');
            $('#date_wise_net_product_sales_date_range').val('');
            table.ajax.reload();
            checkPrintButton();
        });

        $('#date_wise_net_product_sales_date_range').on('apply.daterangepicker', function(ev, picker) {
            table.ajax.reload(null, false);
            checkPrintButton();
        });

        function checkPrintButton() {
            var hasDateRange = $('#date_wise_net_product_sales_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        $('#print_report').on('click', function() {
            var product_id = $('#product_filter').val() == 'single' ? $('#product_id').val() : '';
            var category_id = $('#category_filter').val() == 'single' ? $('#category_id').val() : '';
            var start_date = '';
            var end_date = '';
            
            if ($('#date_wise_net_product_sales_date_range').val()) {
                start_date = $('#date_wise_net_product_sales_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#date_wise_net_product_sales_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            
            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "printDateWiseNetProductSales"]) }}';
            url += '?product_id=' + product_id;
            url += '&category_id=' + category_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;
            
            window.open(url, '_blank');
        });

        checkPrintButton();
    });
</script>
@endsection

