@extends('layouts.app')
@section('title', 'Customer wise Sales Return')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Customer wise Sales Return</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesReturn']), 'method' => 'get', 'id' => 'customer_wise_sales_return_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'customer_wise_sales_return_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', ['all' => __('lang_v1.all_customers'), 'single' => __('lang_v1.single_customer')], !empty($customer_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: {{ !empty($customer_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesReturn']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSalesReturn'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id, 'customer_id' => $customer_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Product Description</th>
                                <th style="text-align: right;">Qty</th>
                                <th style="text-align: right;">Unit Price</th>
                                <th style="text-align: right;">Total Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($sales_return_lines) > 0)
                                @foreach($grouped_data as $customer_id => $customer_lines)
                                    @php
                                        $customer = $customer_lines->first();
                                        $customer_name = $customer->customer_name ?? 'Walking Customer';
                                        if (!empty($customer->supplier_business_name)) {
                                            $customer_name = $customer->supplier_business_name . ' - ' . $customer_name;
                                        }
                                        $customer_total_qty = $customer_lines->sum('quantity');
                                        $customer_total_price = $customer_lines->sum('line_total');
                                        $customer_date_groups = $customer_lines->groupBy('transaction_date');
                                    @endphp
                                    
                                    @foreach($customer_date_groups as $date => $date_lines)
                                        @php
                                            $date_total_qty = $date_lines->sum('quantity');
                                            $date_total_price = $date_lines->sum('line_total');
                                        @endphp
                                        
                                        <!-- Customer Header Row (only show once per customer) -->
                                        @if($loop->first)
                                        <tr style="background-color: #f5f5f5; font-weight: bold;">
                                            <td colspan="2">{{ $customer_name }}</td>
                                            <td style="text-align: right;"></td>
                                            <td style="text-align: right;"></td>
                                            <td style="text-align: right;"></td>
                                        </tr>
                                        @endif
                                        
                                        <!-- Date Header Row -->
                                        <tr style="background-color: #f9f9f9;">
                                            <td colspan="2">{{ $util->format_date($date, false) }}</td>
                                            <td style="text-align: right;"></td>
                                            <td style="text-align: right;"></td>
                                            <td style="text-align: right;"></td>
                                        </tr>
                                        
                                        <!-- Product Rows -->
                                        @foreach($date_lines as $line)
                                        <tr>
                                            <td>{{ $line->invoice_no }}</td>
                                            <td>{{ $line->product_description }}</td>
                                            <td style="text-align: right;">{{ number_format($line->quantity, 2) }}</td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $line->unit_price_inc_tax }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $line->line_total }}</span>
                                            </td>
                                        </tr>
                                        @endforeach
                                        
                                        <!-- Date Subtotal -->
                                        <tr style="background-color: #f5f5f5; font-weight: bold; border-top: 1px solid #ddd;">
                                            <td colspan="2" style="text-align: right;">Sub Total:</td>
                                            <td style="text-align: right;">{{ number_format($date_total_qty, 2) }}</td>
                                            <td style="text-align: right;"></td>
                                            <td style="text-align: right; border-top: 1px solid #000;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $date_total_price }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                    
                                    <!-- Customer Subtotal (only show once per customer) -->
                                    <tr style="background-color: #e8e8e8; font-weight: bold; border-top: 1px solid #ddd;">
                                        <td colspan="2" style="text-align: right;">Customer Total:</td>
                                        <td style="text-align: right;">{{ number_format($customer_total_qty, 2) }}</td>
                                        <td style="text-align: right;"></td>
                                        <td style="text-align: right; border-top: 1px solid #000;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $customer_total_price }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5" class="text-center">No sales return found for the selected filters.</td>
                                </tr>
                            @endif
                        </tbody>
                        <tfoot>
                            <tr style="background-color: #e8e8e8; font-weight: bold; border-top: 2px solid #000;">
                                <td colspan="2" style="text-align: right;">Grand Total:</td>
                                <td style="text-align: right; border-bottom: 2px solid #000;">{{ number_format($grand_total_qty, 2) }}</td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right; border-bottom: 2px solid #000;">
                                    <span class="display_currency" data-currency_symbol="true">{{ $grand_total_price }}</span>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#customer_wise_sales_return_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#customer_wise_sales_return_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#customer_wise_sales_return_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#customer_wise_sales_return_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val('').trigger('change');
            }
        });

        // Reload when date range changes
        $('#customer_wise_sales_return_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection

