@extends('layouts.app')
@section('title', 'Supplier wise Purchase Order')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Supplier wise Purchase Order</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'supplier_wise_purchase_order_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'supplier_wise_purchase_order_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', 'Supplier Filter' . ':') !!}
                        {!! Form::select('supplier_filter', ['all' => 'All Supplier', 'single' => 'Single Supplier'], 'all', ['class' => 'form-control', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="supplier_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('supplier_id', 'Supplier' . ':') !!}
                        {!! Form::select('supplier_id', $suppliers_array, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.please_select'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', 'Product Filter' . ':') !!}
                        {!! Form::select('product_filter', ['all' => 'All Product', 'single' => 'Single Product', 'category' => 'Category'], 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.please_select'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products_array, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.please_select'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="supplier_wise_purchase_order_table">
                        <thead>
                            <tr>
                                <th>Order No</th>
                                <th>Supplier Name</th>
                                <th>Requisition No</th>
                                <th>Product Group</th>
                                <th>Product Description</th>
                                <th>Quantity</th>
                                <th>Unit</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#supplier_wise_purchase_order_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#supplier_wise_purchase_order_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#supplier_wise_purchase_order_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Show/hide supplier select based on filter
        $('#supplier_filter').on('change', function() {
            var filter_value = $(this).val();
            if (filter_value == 'single') {
                $('#supplier_select_container').show();
            } else {
                $('#supplier_select_container').hide();
                $('#supplier_id').val(null).trigger('change');
            }
            supplier_wise_purchase_order_table.ajax.reload();
        });

        // Show/hide category/product select based on filter
        $('#product_filter').on('change', function() {
            var filter_value = $(this).val();
            if (filter_value == 'category') {
                $('#category_select_container').show();
                $('#product_select_container').hide();
                $('#product_id').val(null).trigger('change');
            } else if (filter_value == 'single') {
                $('#product_select_container').show();
                $('#category_select_container').hide();
                $('#category_id').val(null).trigger('change');
            } else {
                $('#category_select_container').hide();
                $('#product_select_container').hide();
                $('#category_id').val(null).trigger('change');
                $('#product_id').val(null).trigger('change');
            }
            supplier_wise_purchase_order_table.ajax.reload();
        });

        // Initialize DataTable
        var supplier_wise_purchase_order_table = $('#supplier_wise_purchase_order_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "supplierWisePurchaseOrder"]) }}',
                data: function(d) {
                    d.supplier_filter = $('#supplier_filter').val();
                    d.supplier_id = '';
                    if ($('#supplier_filter').val() == 'single') {
                        d.supplier_id = $('#supplier_id').val() || '';
                    }
                    d.product_filter = $('#product_filter').val();
                    d.category_id = '';
                    d.product_id = '';
                    if ($('#product_filter').val() == 'category') {
                        d.category_id = $('#category_id').val() || '';
                    } else if ($('#product_filter').val() == 'single') {
                        d.product_id = $('#product_id').val() || '';
                    }
                    d.location_id = $('#location_id').val();
                    if ($('#supplier_wise_purchase_order_date_range').val()) {
                        var start = $('#supplier_wise_purchase_order_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#supplier_wise_purchase_order_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'order_no', name: 'order_no' },
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'requisition_no', name: 'requisition_no' },
                { data: 'product_group', name: 'product_group' },
                { data: 'product_description', name: 'product_description' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit', name: 'unit' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#supplier_wise_purchase_order_table'));
            },
        });

        // Apply filters
        $('#apply_filters').on('click', function() {
            supplier_wise_purchase_order_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#supplier_filter').val('all').trigger('change');
            $('#supplier_id').val('').trigger('change');
            $('#product_filter').val('all').trigger('change');
            $('#category_id').val('').trigger('change');
            $('#product_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#supplier_wise_purchase_order_date_range').val('');
            $('#print_report').hide();
            supplier_wise_purchase_order_table.ajax.reload();
        });

        // Print report
        $('#print_report').on('click', function() {
            var date_range = $('#supplier_wise_purchase_order_date_range').val();
            var supplier_filter = $('#supplier_filter').val();
            var supplier_id = $('#supplier_id').val();
            var product_filter = $('#product_filter').val();
            var category_id = $('#category_id').val();
            var product_id = $('#product_id').val();
            var location_id = $('#location_id').val();

            var url = "{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWisePurchaseOrder']) }}";
            url += '?date_range=' + encodeURIComponent(date_range);
            url += '&supplier_filter=' + supplier_filter;
            if (supplier_id) {
                url += '&supplier_id=' + supplier_id;
            }
            url += '&product_filter=' + product_filter;
            if (category_id) {
                url += '&category_id=' + category_id;
            }
            if (product_id) {
                url += '&product_id=' + product_id;
            }
            if (location_id) {
                url += '&location_id=' + location_id;
            }

            window.open(url, '_blank');
        });

        // Update date range picker callback
        $('#supplier_wise_purchase_order_date_range').on('apply.daterangepicker', function(ev, picker) {
            checkPrintButton();
        });

        $('#supplier_wise_purchase_order_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Filter change handlers
        $('#supplier_id, #category_id, #product_id, #location_id').on('change', function() {
            supplier_wise_purchase_order_table.ajax.reload();
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection

