<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>{{ __('businessmanagement::lang.date_wise_purchase') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tfoot {
            display: table-footer-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        /* Default alignment - will be overridden by specific layouts */
        table tbody td:nth-child(1),
        table tbody td:nth-child(2),
        table tbody td:nth-child(3) {
            text-align: left;
        }
        
        table tbody td:nth-child(4) {
            text-align: center;
        }
        
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7),
        table tbody td:nth-child(8) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        table tbody td:nth-child(9) {
            text-align: center;
        }
        
        /* Supplier-wise layout specific alignment (10 columns) */
        table.supplier-wise tbody td:nth-child(1),
        table.supplier-wise tbody td:nth-child(2),
        table.supplier-wise tbody td:nth-child(3),
        table.supplier-wise tbody td:nth-child(4) {
            text-align: left;
        }
        
        table.supplier-wise tbody td:nth-child(5),
        table.supplier-wise tbody td:nth-child(10) {
            text-align: center;
        }
        
        table.supplier-wise tbody td:nth-child(6),
        table.supplier-wise tbody td:nth-child(7),
        table.supplier-wise tbody td:nth-child(8),
        table.supplier-wise tbody td:nth-child(9) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .date-header-row {
            background-color: #f5f7fa !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .date-header-row td {
            border: 1px solid #ddd;
            border-top: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
            color: #1a1a1a;
        }
        
        /* Footer Rows */
        .total-row {
            background-color: #f8f9fa !important;
            font-weight: 600;
            border-top: 2px solid #2c3e50;
        }
        
        .total-row td {
            border: 1px solid #ddd;
            color: #1a1a1a;
        }
        
        .grand-total-row {
            background-color: #e9ecef !important;
            font-weight: 700;
            font-size: 11pt;
            border-top: 2px solid #2c3e50;
            border-bottom: 3px double #2c3e50 !important;
        }
        
        .grand-total-row td {
            border: 1px solid #ddd;
            border-bottom: 3px double #2c3e50 !important;
            color: #1a1a1a;
        }
        
        .link-cell {
            color: #0066cc;
            text-decoration: underline;
            cursor: pointer;
        }
        
        .link-cell a {
            color: #0066cc;
            text-decoration: underline;
            font-weight: 500;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        /* Print Controls */
        .no-print {
            text-align: center;
            margin-top: 20px;
            padding: 15px;
        }
        
        .btn {
            padding: 10px 20px;
            margin: 0 5px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
        }
        
        .btn-primary {
            background-color: #007bff;
            color: #fff;
        }
        
        .btn-primary:hover {
            background-color: #0056b3;
        }
        
        .btn-default {
            background-color: #6c757d;
            color: #fff;
        }
        
        .btn-default:hover {
            background-color: #545b62;
        }
        
        /* Print Media Queries */
        @media print {
            @page {
                size: A4;
                margin: 1cm 1.5cm;
            }
            
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            
            body {
                margin: 0;
                padding: 0;
                font-size: 10pt;
            }
            
            .no-print {
                display: none !important;
            }
            
            .header {
                page-break-after: avoid;
                margin-bottom: 12px;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .report-info {
                page-break-after: avoid;
            }
            
            table thead {
                display: table-header-group;
            }
            
            table tfoot {
                display: table-footer-group;
            }
            
            table tbody tr {
                page-break-inside: avoid;
            }
            
            .date-header-row {
                page-break-after: avoid;
            }
            
            .total-row,
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
        
        @media screen {
            body {
                padding: 20px;
                background-color: #f5f5f5;
            }
            
            .container {
                background-color: #fff;
                padding: 30px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                max-width: 210mm;
                margin: 0 auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">
            @if(!empty($is_supplier_wise))
                Supplier wise Purchase
            @else
                {{ __('businessmanagement::lang.date_wise_purchase') }}
            @endif
        </div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, true) }} {{ __('lang_v1.to') }} {{ $util->format_date($end_date, true) }}
            @endif
            @if(!empty($is_supplier_wise) && $supplier_name != __('lang_v1.all_suppliers'))
                @if(!empty($start_date) && !empty($end_date))
                    <br>
                @endif
                {{ __('purchase.supplier') }}: {{ $supplier_name }}
            @endif
        </div>

        <!-- Data Table -->
        <div class="table-container">
            <table @if(!empty($is_supplier_wise)) class="supplier-wise" @endif>
                <thead>
                    <tr>
                        @if(!empty($is_supplier_wise))
                            <th style="width: 10%;">Date</th>
                            <th style="width: 12%;">Invoice No</th>
                            <th style="width: 10%;">Ref No</th>
                            <th style="width: 12%;">Entered by</th>
                            <th style="width: 9%;">Bill Type</th>
                            <th style="width: 9%;">Discount</th>
                            <th style="width: 9%;">Extra Charges</th>
                            <th style="width: 9%;">VAT</th>
                            <th style="width: 11%;">Total Amount</th>
                            <th style="width: 9%;">Link</th>
                        @else
                            <th style="width: 13%;">Invoice No</th>
                            <th style="width: 11%;">Reference No</th>
                            <th style="width: 18%;">Supplier</th>
                            <th style="width: 9%;">Bill Type</th>
                            <th style="width: 9%;">Discount</th>
                            <th style="width: 9%;">Ex. Ch.</th>
                            <th style="width: 9%;">VAT</th>
                            <th style="width: 12%;">Total Amount</th>
                            <th style="width: 10%;">Link</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @if(!empty($is_supplier_wise))
                        @forelse($purchases as $purchase)
                            @php
                                $discount = $purchase->discount_amount ?? 0;
                                if (!empty($discount) && $purchase->discount_type == 'percentage') {
                                    $discount = $purchase->total_before_tax * ($discount / 100);
                                }
                                
                                $extra_charges = $purchase->shipping_charges ?? 0;
                                $extra_charges += $purchase->additional_expense_value_1 ?? 0;
                                $extra_charges += $purchase->additional_expense_value_2 ?? 0;
                                $extra_charges += $purchase->additional_expense_value_3 ?? 0;
                                $extra_charges += $purchase->additional_expense_value_4 ?? 0;
                                
                                $ref_no = !empty($purchase->invoice_no) ? $purchase->invoice_no : '';
                                
                                $bill_type = $purchase->payment_status == 'paid' ? __('businessmanagement::lang.cash') : 
                                            ($purchase->payment_status == 'due' ? __('businessmanagement::lang.credit') : 
                                            ($purchase->payment_status == 'partial' ? __('businessmanagement::lang.partial') : ucfirst($purchase->payment_status)));
                            @endphp
                            <tr>
                                <td>{{ $util->format_date($purchase->transaction_date, true) }}</td>
                                <td>{{ $purchase->invoice_no ?? '' }}</td>
                                <td>{{ $ref_no }}</td>
                                <td>{{ $purchase->entered_by ?? '' }}</td>
                                <td class="text-center">{{ $bill_type }}</td>
                                <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($discount) }}</td>
                                <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($extra_charges) }}</td>
                                <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($purchase->tax_amount ?? 0) }}</td>
                                <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($purchase->final_total) }}</td>
                                <td class="text-center link-cell">
                                    <a href="{{ action([\App\Http\Controllers\PurchaseController::class, 'show'], [$purchase->id]) }}" target="_blank" style="color: #0066cc; text-decoration: underline;">Click</a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="10" class="text-center">{{ __('lang_v1.no_data_available') }}</td>
                            </tr>
                        @endforelse
                    @else
                        @if(!empty($purchases_by_date))
                            @foreach($purchases_by_date as $date => $date_purchases)
                                <!-- Date Header Row -->
                                <tr class="date-header-row">
                                    <td colspan="9">{{ $util->format_date($date, true) }}</td>
                                </tr>
                                
                                @foreach($date_purchases as $purchase)
                                @php
                                    $discount = $purchase->discount_amount ?? 0;
                                    if (!empty($discount) && $purchase->discount_type == 'percentage') {
                                        $discount = $purchase->total_before_tax * ($discount / 100);
                                    }
                                    
                                    $extra_charges = $purchase->shipping_charges ?? 0;
                                    $extra_charges += $purchase->additional_expense_value_1 ?? 0;
                                    $extra_charges += $purchase->additional_expense_value_2 ?? 0;
                                    $extra_charges += $purchase->additional_expense_value_3 ?? 0;
                                    $extra_charges += $purchase->additional_expense_value_4 ?? 0;
                                    
                                    $ref_no = !empty($purchase->invoice_no) ? $purchase->invoice_no : '';
                                    
                                    $supplier = $purchase->supplier_name ?? '';
                                    if (!empty($purchase->supplier_business_name)) {
                                        $supplier .= ' (' . $purchase->supplier_business_name . ')';
                                    }
                                    
                                    $bill_type = $purchase->payment_status == 'paid' ? __('businessmanagement::lang.cash') : 
                                                ($purchase->payment_status == 'due' ? __('businessmanagement::lang.credit') : 
                                                ($purchase->payment_status == 'partial' ? __('businessmanagement::lang.partial') : ucfirst($purchase->payment_status)));
                                @endphp
                                <tr>
                                    <td>{{ $purchase->invoice_no ?? '' }}</td>
                                    <td>{{ $ref_no }}</td>
                                    <td>{{ $supplier }}</td>
                                    <td class="text-center">{{ $bill_type }}</td>
                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($discount) }}</td>
                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($extra_charges) }}</td>
                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($purchase->tax_amount ?? 0) }}</td>
                                    <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($purchase->final_total) }}</td>
                                    <td class="text-center link-cell">
                                        <a href="{{ action([\App\Http\Controllers\PurchaseController::class, 'show'], [$purchase->id]) }}" target="_blank" style="color: #0066cc; text-decoration: underline;">Click</a>
                                    </td>
                                </tr>
                                @endforeach
                            @endforeach
                        @else
                            <tr>
                                <td colspan="9" class="text-center">{{ __('lang_v1.no_data_available') }}</td>
                            </tr>
                        @endif
                    @endif
                </tbody>
                <tfoot>
                    @if(!empty($is_supplier_wise))
                        <tr class="total-row">
                            <td colspan="5" class="text-left"><strong>Sub Total:</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_discount) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_extra_charges) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_tax) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_amount) }}</strong></td>
                            <td></td>
                        </tr>
                        <tr class="grand-total-row">
                            <td colspan="5" class="text-left"><strong>Grand Total:</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_discount) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_extra_charges) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_tax) }}</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_amount) }}</strong></td>
                            <td></td>
                        </tr>
                    @else
                        <tr class="total-row">
                            <td colspan="4" class="text-left"><strong>Sub Total:</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_discount) }}</strong></td>
                            <td></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_amount) }}</strong></td>
                            <td></td>
                        </tr>
                        <tr class="grand-total-row">
                            <td colspan="4" class="text-left"><strong>Grand Total:</strong></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_discount) }}</strong></td>
                            <td></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($total_amount) }}</strong></td>
                            <td></td>
                        </tr>
                    @endif
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Print Controls -->
    <div class="no-print">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="fa fa-print"></i> {{ __('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-default">
            {{ __('messages.close') }}
        </button>
    </div>

    <script>
        window.onload = function() {
            // Optional: Auto focus for print
        };
    </script>
</body>
</html>
