<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Receive & Payment Statement</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
            text-align: left;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
            text-align: left;
        }
        
        .company-contact strong {
            font-weight: 700;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #1a1a1a;
            font-weight: 700;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table th {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: left;
            font-weight: 700;
            font-size: 8pt;
            background-color: #f5f5f5;
        }
        
        table th:last-child,
        table th:nth-child(2),
        table th:nth-child(3) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 4px;
            font-size: 8pt;
        }
        
        table td:last-child,
        table td:nth-child(2),
        table td:nth-child(3) {
            text-align: right;
        }
        
        .section-header {
            font-weight: 700;
            background-color: #f5f5f5;
        }
        
        .subtotal-row {
            font-weight: 700;
        }
        
        .footer {
            margin-top: 10px;
            font-size: 7pt;
            text-align: center;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}{{ !empty($business->address_line_1) && !empty($business->city) ? ', ' : '' }}{{ $business->city ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city)) && !empty($business->state) ? ', ' : '' }}{{ $business->state ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city) || !empty($business->state)) && !empty($business->country) ? ', ' : '' }}{{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <strong>Phone</strong> {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <strong>Email</strong> {{ $business->email }}
                    @endif
                </div>
            </div>
            <div class="header-right">
                <!-- Empty for alignment -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Receive & Payment Statement</div>
        <div class="report-date">{{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}</div>
        
        <!-- Receipt Payment Table -->
        <table>
            <thead>
                <tr>
                    <th>Particulars</th>
                    <th>Cash</th>
                    <th>Bank</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <!-- Opening Section -->
                <tr class="section-header">
                    <td>Opening</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td style="padding-left: 20px;">Opening Balance</td>
                    <td>{{ $util->num_f($opening_cash, true, null) }}</td>
                    <td>{{ $util->num_f($opening_bank, true, null) }}</td>
                    <td>{{ $util->num_f($opening_total, true, null) }}</td>
                </tr>
                <tr class="subtotal-row">
                    <td style="padding-left: 20px;">Opening Balance Sub Total:</td>
                    <td>{{ $util->num_f($opening_cash, true, null) }}</td>
                    <td>{{ $util->num_f($opening_bank, true, null) }}</td>
                    <td>{{ $util->num_f($opening_total, true, null) }}</td>
                </tr>
                <tr class="subtotal-row">
                    <td>Opening Sub Total:</td>
                    <td>{{ $util->num_f($opening_cash, true, null) }}</td>
                    <td>{{ $util->num_f($opening_bank, true, null) }}</td>
                    <td>{{ $util->num_f($opening_total, true, null) }}</td>
                </tr>
                
                <!-- Receive Section -->
                <tr class="section-header">
                    <td>Receive</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                @foreach($receipt_data as $account_name => $data)
                    <tr>
                        <td style="padding-left: 20px;">{{ $account_name }}</td>
                        <td>{{ $util->num_f($data['cash'], true, null) }}</td>
                        <td>{{ $util->num_f($data['bank'], true, null) }}</td>
                        <td>{{ $util->num_f($data['total'], true, null) }}</td>
                    </tr>
                    <tr class="subtotal-row">
                        <td style="padding-left: 20px;">{{ $account_name }} Sub Total:</td>
                        <td>{{ $util->num_f($data['cash'], true, null) }}</td>
                        <td>{{ $util->num_f($data['bank'], true, null) }}</td>
                        <td>{{ $util->num_f($data['total'], true, null) }}</td>
                    </tr>
                @endforeach
                <tr class="subtotal-row">
                    <td>Receive Sub Total:</td>
                    <td>{{ $util->num_f($total_receipt_cash, true, null) }}</td>
                    <td>{{ $util->num_f($total_receipt_bank, true, null) }}</td>
                    <td>{{ $util->num_f($total_receipt_total, true, null) }}</td>
                </tr>
                
                <!-- Payment Section -->
                <tr class="section-header">
                    <td>Payment</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                @foreach($payment_data as $category_name => $data)
                    <tr>
                        <td style="padding-left: 20px;">{{ $category_name }}</td>
                        <td>{{ $util->num_f($data['cash'], true, null) }}</td>
                        <td>{{ $util->num_f($data['bank'], true, null) }}</td>
                        <td>{{ $util->num_f($data['total'], true, null) }}</td>
                    </tr>
                    @if(!empty($data['items']))
                        @foreach($data['items'] as $item)
                            <tr>
                                <td style="padding-left: 40px;">{{ $item['name'] }}</td>
                                <td>{{ $util->num_f($item['cash'], true, null) }}</td>
                                <td>{{ $util->num_f($item['bank'], true, null) }}</td>
                                <td>{{ $util->num_f($item['total'], true, null) }}</td>
                            </tr>
                        @endforeach
                    @endif
                    <tr class="subtotal-row">
                        <td style="padding-left: 20px;">{{ $category_name }} Sub Total:</td>
                        <td>{{ $util->num_f($data['cash'], true, null) }}</td>
                        <td>{{ $util->num_f($data['bank'], true, null) }}</td>
                        <td>{{ $util->num_f($data['total'], true, null) }}</td>
                    </tr>
                @endforeach
                <tr class="subtotal-row">
                    <td>Payment Sub Total:</td>
                    <td>{{ $util->num_f($total_payment_cash, true, null) }}</td>
                    <td>{{ $util->num_f($total_payment_bank, true, null) }}</td>
                    <td>{{ $util->num_f($total_payment_total, true, null) }}</td>
                </tr>
                
                <!-- Closing Section -->
                <tr class="section-header">
                    <td>Closing</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td style="padding-left: 20px;">Closing Balance</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td style="padding-left: 20px;">Closing Balance</td>
                    <td>{{ $util->num_f($closing_cash, true, null) }}</td>
                    <td>{{ $util->num_f($closing_bank, true, null) }}</td>
                    <td>{{ $util->num_f($closing_total, true, null) }}</td>
                </tr>
                <tr class="subtotal-row">
                    <td style="padding-left: 20px;">Closing Balance Sub Total:</td>
                    <td>{{ $util->num_f($closing_cash, true, null) }}</td>
                    <td>{{ $util->num_f($closing_bank, true, null) }}</td>
                    <td>{{ $util->num_f($closing_total, true, null) }}</td>
                </tr>
                <tr class="subtotal-row">
                    <td>Closing Sub Total:</td>
                    <td>{{ $util->num_f($closing_cash, true, null) }}</td>
                    <td>{{ $util->num_f($closing_bank, true, null) }}</td>
                    <td>{{ $util->num_f($closing_total, true, null) }}</td>
                </tr>
            </tbody>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div>Print Date & Time: {{ date('d/m/Y h:i:s A') }}</div>
        </div>
    </div>
</body>
</html>

