@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_net_profit'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_net_profit') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseNetProfit']), 'method' => 'get', 'id' => 'date_wise_net_profit_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'date_wise_net_profit_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'date_wise_net_profit_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseNetProfit']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(isset($date_wise_data) && count($date_wise_data) > 0)
                                <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseNetProfit'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '']) }}" 
                                   target="_blank" 
                                   class="btn btn-success">
                                    <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">{{ __('businessmanagement::lang.date_wise_net_profit') }} 
                        ({{ !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : '' }} 
                        {{ __('businessmanagement::lang.to') }} 
                        {{ !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : '' }})
                    </h3>
                </div>
                <div class="box-body">
                    @if(isset($date_wise_data) && count($date_wise_data) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr style="background-color: #f5f5f5; font-weight: bold;">
                                        <th>{{ __('businessmanagement::lang.date') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.total_sell_amount') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.sell_discount') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.cogs') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.gross_profit') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.expense') }}</th>
                                        <th style="text-align: right;">{{ __('businessmanagement::lang.net_profit') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($date_wise_data as $data)
                                        <tr>
                                            <td>{{ \Carbon\Carbon::parse($data['date'])->format('d-m-Y') }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($data['total_sales'], true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($data['sales_discount'], true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($data['cogs'], true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($data['gross_profit'], true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($data['expenses'], true, null) }}</td>
                                            <td style="text-align: right; font-weight: bold; color: {{ $data['net_profit'] >= 0 ? '#28a745' : '#dc3545' }};">
                                                {{ $util->num_f($data['net_profit'], true, null) }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr style="background-color: #f5f5f5; font-weight: bold; border-top: 2px solid #333;">
                                        <td style="font-weight: bold;">{{ __('businessmanagement::lang.total') }}</td>
                                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_sales, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_discount, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_cogs, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_gross_profit, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_expenses, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; font-size: 16px; color: {{ $grand_total_net_profit >= 0 ? '#28a745' : '#dc3545' }};">
                                            {{ $util->num_f($grand_total_net_profit, true, null) }}
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> {{ __('businessmanagement::lang.no_data_found') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>

@endsection

@section('javascript')
<style>
    /* Fix datepicker calendar positioning */
    .datepicker {
        z-index: 9999 !important;
    }
    
    .datepicker-dropdown {
        z-index: 9999 !important;
        position: absolute !important;
    }
    
    /* Ensure calendar appears below the input field */
    .ui-datepicker {
        z-index: 9999 !important;
        position: absolute !important;
    }
    
    /* Fix for jQuery UI datepicker */
    .ui-datepicker.ui-widget.ui-widget-content {
        z-index: 9999 !important;
        position: absolute !important;
    }
    
    /* Ensure form group has relative positioning for proper calendar placement */
    .form-group {
        position: relative;
    }
    
    /* Fix calendar positioning when inside filters component */
    .filters .form-group {
        position: relative;
    }
</style>
<script type="text/javascript">
    $(document).ready(function() {
        // Date picker initialization with proper positioning
        $('#date_wise_net_profit_start_date, #date_wise_net_profit_end_date').datepicker({
            autoclose: true,
            format: 'dd/mm/yyyy',
            orientation: 'bottom auto',
            zIndexOffset: 9999
        });

        // Update hidden fields when date picker changes
        $('#date_wise_net_profit_start_date').on('changeDate', function(e) {
            var date = e.format('yyyy-mm-dd');
            $('#hidden_start_date').val(date);
        });

        $('#date_wise_net_profit_end_date').on('changeDate', function(e) {
            var date = e.format('yyyy-mm-dd');
            $('#hidden_end_date').val(date);
        });
    });
</script>
@endsection

