@extends('layouts.app')
@section('title', __('businessmanagement::lang.supplier_wise_current_stock'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.supplier_wise_current_stock') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'supplierWiseCurrentStock']), 'method' => 'get', 'id' => 'supplier_wise_current_stock_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'supplierWiseCurrentStock']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printSupplierWiseCurrentStock'], ['location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $supplier_name => $categories)
                            <h3 style="margin-top: 30px; margin-bottom: 15px; font-weight: bold; color: #2c3e50; font-size: 18px;">{{ $supplier_name }}</h3>
                            @foreach($categories as $category_name => $items)
                                <h4 style="margin-top: 20px; margin-bottom: 10px; font-weight: bold; color: #495057; font-size: 14px;">{{ $category_name }}</h4>
                                <table class="table table-bordered table-striped" style="font-size: 12px; margin-bottom: 15px;">
                                    <thead>
                                        <tr>
                                            <th>Product ID</th>
                                            <th>Product Description</th>
                                            <th style="text-align: right;">Qty</th>
                                            <th style="text-align: right;">Unit Cost</th>
                                            <th style="text-align: right;">Total Cost</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $category_total_qty = 0;
                                            $category_total_cost = 0;
                                        @endphp
                                        @foreach($items as $item)
                                            @php
                                                $category_total_qty += $item->qty;
                                                $category_total_cost += $item->total_cost;
                                            @endphp
                                            <tr>
                                                <td>{{ $item->product_id }}</td>
                                                <td>{{ $item->product_description }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($item->qty, false, null, true) }}</td>
                                                <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->unit_cost }}</span></td>
                                                <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->total_cost }}</span></td>
                                            </tr>
                                        @endforeach
                                        <tr style="background-color: #f8f9fa; font-weight: bold;">
                                            <td colspan="2"><strong>Sub Total:</strong></td>
                                            <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty, false, null, true) }}</strong></td>
                                            <td></td>
                                            <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $category_total_cost }}</span></strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            @endforeach
                            @php
                                $supplier_total_qty = 0;
                                $supplier_total_cost = 0;
                                foreach ($categories as $category_items) {
                                    foreach ($category_items as $item) {
                                        $supplier_total_qty += $item->qty;
                                        $supplier_total_cost += $item->total_cost;
                                    }
                                }
                            @endphp
                            <table class="table table-bordered" style="font-size: 13px; margin-bottom: 30px;">
                                <tbody>
                                    <tr style="background-color: #d4edda; font-weight: bold; font-size: 14px;">
                                        <td colspan="2"><strong>Sub Total : {{ $supplier_name }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($supplier_total_qty, false, null, true) }}</strong></td>
                                        <td></td>
                                        <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $supplier_total_cost }}</span></strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No stock data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });
    });
</script>
@endsection

