@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_stock_serial_m'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_stock_serial_m') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStockSerialM']), 'method' => 'get', 'id' => 'date_wise_stock_serial_m_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date', __('businessmanagement::lang.date') . ':') !!}
                        {!! Form::text('date', $date ?? date('Y-m-d'), ['class' => 'form-control date-picker', 'id' => 'date', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStockSerialM']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseStockSerialM'], ['date' => $date ?? date('Y-m-d'), 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $supplier_name => $items)
                            <h3 style="margin-top: 30px; margin-bottom: 15px; font-weight: bold; color: #2c3e50; font-size: 18px;">{{ $supplier_name }}</h3>
                            <table class="table table-bordered table-striped" style="font-size: 12px; margin-bottom: 15px;">
                                <thead>
                                    <tr>
                                        <th>Invoice No</th>
                                        <th>Date</th>
                                        <th>Supplier Name</th>
                                        <th style="text-align: right;">Qty</th>
                                        <th>Status</th>
                                        <th>Serial</th>
                                        <th style="text-align: right;">Unit Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $supplier_total_qty = 0;
                                        $supplier_total_cost = 0;
                                    @endphp
                                    @foreach($items as $item)
                                        @php
                                            $supplier_total_qty += $item->qty;
                                            $supplier_total_cost += $item->qty * $item->unit_cost;
                                        @endphp
                                        <tr>
                                            <td>{{ $item->invoice_no }}</td>
                                            <td>{{ \Carbon\Carbon::parse($item->transaction_date)->format('d/m/Y') }}</td>
                                            <td>{{ $item->supplier_name }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty, false, null, true) }}</td>
                                            <td>{{ $item->status }}</td>
                                            <td>{{ $item->serial_number ?? '-' }}</td>
                                            <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->unit_cost }}</span></td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="2"></td>
                                        <td><strong>Sub Total</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($supplier_total_qty, false, null, true) }}</strong></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $supplier_total_cost }}</span></strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #d4edda; font-weight: bold;">
                                    <td colspan="3"><strong>Total:</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty, false, null, true) }}</strong></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $grand_total_cost }}</span></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No stock data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });
    });
</script>
@endsection

