@extends('layouts.app')
@section('title', 'Product Wise Sales Summary')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Product Wise Sales Summary</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesSummary']), 'method' => 'get', 'id' => 'product_wise_sales_summary_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_wise_sales_summary_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesSummary']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSalesSummary'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered table-striped" style="font-size: 12px;">
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Customer</th>
                                <th>Product Model</th>
                                <th style="text-align: right;">Qty</th>
                                <th style="text-align: right;">Unit Price</th>
                                <th style="text-align: right;">Discount</th>
                                <th style="text-align: right;">Net Unit Price</th>
                                <th style="text-align: right;">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($sales_lines) > 0)
                                @foreach($sales_lines as $line)
                                    <tr>
                                        <td>{{ $line->invoice_no }}</td>
                                        <td>
                                            @if(!empty($line->supplier_business_name))
                                                {{ $line->supplier_business_name }}
                                            @else
                                                {{ $line->customer_name ?? 'WALKING CUSTOMER' }}
                                            @endif
                                        </td>
                                        <td>{{ $line->product_model }}</td>
                                        <td style="text-align: right;">{{ number_format($line->qty, 2) }}</td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $line->unit_price }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $line->discount }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $line->net_unit_price }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $line->amount }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="8" class="text-center">No sales data found for the selected filters.</td>
                                </tr>
                            @endif
                        </tbody>
                        <tfoot>
                            <tr style="background-color: #e8e8e8; font-weight: bold; border-top: 2px solid #000;">
                                <td colspan="7" style="text-align: right;">Grand Total:</td>
                                <td style="text-align: right; border-bottom: 2px solid #000;">
                                    <span class="display_currency" data-currency_symbol="true">{{ $grand_total_amount }}</span>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#product_wise_sales_summary_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#product_wise_sales_summary_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_wise_sales_summary_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#product_wise_sales_summary_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Reload when date range changes
        $('#product_wise_sales_summary_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection


