<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Supplier wise Purchase</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Supplier Section */
        .supplier-section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .supplier-header {
            font-size: 14pt;
            font-weight: 600;
            margin-bottom: 10px;
            color: #1a1a1a;
            padding: 8px;
            background-color: #f5f7fa;
            border-left: 4px solid #2c3e50;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 15px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td:nth-child(1),
        table tbody td:nth-child(2) {
            text-align: left;
        }
        
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .date-header-row {
            background-color: #f5f7fa !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .date-header-row td {
            border: 1px solid #ddd;
            border-top: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
            color: #1a1a1a;
        }
        
        /* Supplier Total Row */
        .supplier-total-row {
            background-color: #e9ecef !important;
            font-weight: 700;
            font-size: 11pt;
            border-top: 2px solid #2c3e50;
        }
        
        .supplier-total-row td {
            border: 1px solid #ddd;
            color: #1a1a1a;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        /* Print Controls */
        .no-print {
            text-align: center;
            margin-top: 20px;
            padding: 15px;
        }
        
        .btn {
            padding: 10px 20px;
            margin: 0 5px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
        }
        
        .btn-primary {
            background-color: #007bff;
            color: #fff;
        }
        
        .btn-primary:hover {
            background-color: #0056b3;
        }
        
        .btn-default {
            background-color: #6c757d;
            color: #fff;
        }
        
        .btn-default:hover {
            background-color: #545b62;
        }
        
        /* Print Media Queries */
        @media print {
            @page {
                size: A4;
                margin: 1cm 1.5cm;
            }
            
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            
            body {
                margin: 0;
                padding: 0;
                font-size: 10pt;
            }
            
            .no-print {
                display: none !important;
            }
            
            .header {
                page-break-after: avoid;
                margin-bottom: 12px;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .report-info {
                page-break-after: avoid;
            }
            
            .supplier-section {
                page-break-inside: avoid;
            }
            
            table thead {
                display: table-header-group;
            }
            
            table tbody tr {
                page-break-inside: avoid;
            }
            
            .supplier-total-row {
                page-break-inside: avoid;
            }
        }
        
        @media screen {
            body {
                padding: 20px;
                background-color: #f5f5f5;
            }
            
            .container {
                background-color: #fff;
                padding: 30px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                max-width: 210mm;
                margin: 0 auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Supplier wise Purchase</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, true) }} To {{ $util->format_date($end_date, true) }}
            @endif
            @if(!empty($is_single_supplier) && !empty($supplier_name))
                @if(!empty($start_date) && !empty($end_date))
                    <br>
                @endif
                {{ __('purchase.supplier') }}: {{ $supplier_name }}
            @endif
        </div>

        <!-- Supplier Sections -->
        @forelse($suppliers_data as $supplier_id => $supplier_data)
            <div class="supplier-section">
                @if(empty($is_single_supplier))
                    <!-- Supplier Header (only show when multiple suppliers) -->
                    <div class="supplier-header">
                        Supplier Name: {{ $supplier_data['supplier_name'] }}
                        @if(!empty($supplier_data['supplier_business_name']))
                            ({{ $supplier_data['supplier_business_name'] }})
                        @endif
                    </div>
                @endif

                <!-- Supplier Table -->
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 12%;">Invoice No</th>
                                <th style="width: 40%;">Product Description</th>
                                <th style="width: 12%;">Qty</th>
                                <th style="width: 18%;">Unit Price</th>
                                <th style="width: 18%;">Total Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($supplier_data['lines'] as $date => $lines)
                                <!-- Date Header Row -->
                                <tr class="date-header-row">
                                    <td colspan="5">{{ $util->format_date($date, true) }}</td>
                                </tr>
                                
                                @foreach($lines as $line)
                                    <tr>
                                        <td>{{ $line->invoice_no ?? '' }}</td>
                                        <td>{{ $line->product_description ?? '' }}</td>
                                        <td class="text-right">{{ $util->num_f($line->quantity) }}</td>
                                        <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($line->purchase_price_inc_tax) }}</td>
                                        <td class="text-right">{{ $currency['symbol'] ?? '' }}{{ $util->num_f($line->line_total) }}</td>
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="supplier-total-row">
                                <td colspan="2" class="text-left"><strong>Supplier wise Total:</strong></td>
                                <td class="text-right"><strong>{{ $util->num_f($supplier_data['total_qty']) }}</strong></td>
                                <td></td>
                                <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($supplier_data['total_price']) }}</strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        @empty
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>{{ __('lang_v1.no_data_available') }}</p>
            </div>
        @endforelse
        
        @if(count($suppliers_data) > 0)
            <!-- Grand Total -->
            <div class="table-container" style="margin-top: 20px;">
                <table>
                    <tfoot>
                        <tr class="supplier-total-row" style="border-top: 2px solid #2c3e50; border-bottom: 3px double #2c3e50;">
                            <td colspan="2" class="text-left"><strong>Grand Total:</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($grand_total_qty) }}</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $currency['symbol'] ?? '' }}{{ $util->num_f($grand_total_price) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif
    </div>

    <!-- Print Controls -->
    <div class="no-print">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="fa fa-print"></i> {{ __('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-default">
            {{ __('messages.close') }}
        </button>
    </div>

    <script>
        window.onload = function() {
            // Optional: Auto focus for print
        };
    </script>
</body>
</html>

