@extends('layouts.app')
@section('title', 'Date wise Purchase Return')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Date wise Purchase Return</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'date_wise_purchase_return_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_wise_purchase_return_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="date_wise_purchase_return_table">
                        <thead>
                            <tr>
                                <th>@lang('sale.date')</th>
                                <th>@lang('purchase.invoice_no')</th>
                                <th>Customer Name</th>
                                <th>Narration</th>
                                <th>Total Amount</th>
                                <th>Discount</th>
                                <th>Ex. Charges</th>
                                <th>@lang('sale.total')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#date_wise_purchase_return_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#date_wise_purchase_return_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#date_wise_purchase_return_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Initialize DataTable
        var date_wise_purchase_return_table = $('#date_wise_purchase_return_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "dateWisePurchaseReturn"]) }}',
                data: function(d) {
                    d.location_id = $('#location_id').val();
                    if ($('#date_wise_purchase_return_date_range').val()) {
                        var start = $('#date_wise_purchase_return_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#date_wise_purchase_return_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'narration', name: 'narration' },
                { data: 'total_amount', name: 'total_amount' },
                { data: 'discount', name: 'discount' },
                { data: 'ex_charges', name: 'ex_charges' },
                { data: 'amount', name: 'amount' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#date_wise_purchase_return_table'));
            },
        });

        // Apply filters
        $('#apply_filters').on('click', function() {
            date_wise_purchase_return_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#location_id').val('').trigger('change');
            $('#date_wise_purchase_return_date_range').val('');
            $('#print_report').hide();
            date_wise_purchase_return_table.ajax.reload();
        });

        // Print report
        $('#print_report').on('click', function() {
            var date_range = $('#date_wise_purchase_return_date_range').val();
            var location_id = $('#location_id').val();

            var url = "{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printDateWisePurchaseReturn']) }}";
            url += '?date_range=' + encodeURIComponent(date_range);
            if (location_id) {
                url += '&location_id=' + location_id;
            }

            window.open(url, '_blank');
        });

        // Update date range picker callback
        $('#date_wise_purchase_return_date_range').on('apply.daterangepicker', function(ev, picker) {
            checkPrintButton();
        });

        $('#date_wise_purchase_return_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection

